/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.spam.Token;
import com.limegroup.gnutella.spam.Tokenizer;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RatingTable {
    private static final Log LOG = LogFactory.getLog(Tokenizer.class);
    private static final int MAX_SIZE = 50000;
    private static final RatingTable INSTANCE = new RatingTable();
    private final Map _tokenMap = this.readData();

    public static RatingTable instance() {
        return INSTANCE;
    }

    private RatingTable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("size of tokenSet " + this._tokenMap.size());
        }
    }

    synchronized void clear() {
        this._tokenMap.clear();
    }

    float getRating(RemoteFileDesc desc) {
        float ret = this.getRating(this.lookup(Tokenizer.getTokens(desc)));
        if (LOG.isDebugEnabled()) {
            LOG.debug(desc.toString() + " rated " + ret);
        }
        return ret;
    }

    float getRating(Token[] tokens) {
        float rating = 1.0f;
        for (int i = 0; i < tokens.length && rating > 0.0f; rating *= 1.0f - tokens[i].getRating(), ++i) {
        }
        float bad = SearchSettings.FILTER_SPAM_RESULTS.getValue();
        if ((rating = 1.0f - rating) >= bad && rating <= 0.995f) {
            this.markInternal(tokens, 2);
        } else if (rating <= 1.0f - bad) {
            this.markInternal(tokens, 4);
        }
        return rating;
    }

    void mark(RemoteFileDesc[] descs, int rating) {
        this.markInternal(this.lookup(Tokenizer.getTokens(descs)), rating);
    }

    void mark(RemoteFileDesc desc, int rating) {
        this.markInternal(this.lookup(Tokenizer.getTokens(desc)), rating);
    }

    void mark(QueryRequest qr, int rating) {
        this.markInternal(this.lookup(Tokenizer.getTokens(qr)), rating);
    }

    private void markInternal(Token[] tokens, int rating) {
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i].rate(rating);
        }
    }

    private Token[] lookup(Token[] tokens) {
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = this.lookup(tokens[i]);
        }
        return tokens;
    }

    private synchronized Token lookup(Token token) {
        Token stored = (Token)this._tokenMap.get(token);
        if (stored == null) {
            this._tokenMap.put(token, token);
            this.checkSize();
            stored = token;
        }
        return stored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map readData() {
        HashMap hashMap;
        ObjectInputStream is;
        block6: {
            is = null;
            is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(RatingTable.getSpamDat())));
            Object read = is.readObject();
            if (!(read instanceof Map)) break block6;
            Map map = (Map)read;
            IOUtils.close(is);
            return map;
        }
        try {
            hashMap = new HashMap();
        }
        catch (Throwable someKindOfError) {
            try {
                HashMap hashMap2 = new HashMap();
                return hashMap2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.close(is);
            }
        }
        IOUtils.close(is);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        HashMap copy;
        RatingTable ratingTable = this;
        synchronized (ratingTable) {
            if (this._tokenMap.size() > 50000) {
                this.pruneEntries();
            }
            copy = new HashMap(this._tokenMap);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("size of tokenMap " + copy.size());
        }
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(RatingTable.getSpamDat())));
            oos.writeObject(copy);
            oos.flush();
            IOUtils.close(oos);
        }
        catch (IOException iox) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("saving rating table failed", iox);
            }
        }
        finally {
            IOUtils.close(oos);
        }
    }

    public synchronized void ageAndSave() {
        Iterator iter = this._tokenMap.values().iterator();
        while (iter.hasNext()) {
            ((Token)iter.next()).incrementAge();
        }
        this.save();
    }

    private synchronized void checkSize() {
        if (this._tokenMap.size() < 100000) {
            return;
        }
        this.pruneEntries();
    }

    private void pruneEntries() {
        int tokensToRemove;
        if (LOG.isDebugEnabled()) {
            LOG.debug("pruning unimportant entries from RatingTable");
        }
        if ((tokensToRemove = this._tokenMap.size() - 50000) <= 0) {
            return;
        }
        TreeSet sortedTokens = new TreeSet(this._tokenMap.values());
        Iterator it = sortedTokens.iterator();
        while (tokensToRemove > 0) {
            this._tokenMap.remove(it.next());
            --tokensToRemove;
        }
    }

    private static File getSpamDat() {
        return new File(CommonUtils.getUserSettingsDir(), "spam.dat");
    }
}

