/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.spam.RatingTable;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpamManager {
    private static final Log LOG = LogFactory.getLog(SpamManager.class);
    public static final float MAX_THRESHOLD = 0.995f;
    private static final float NO_SHA1_URN_RATING = 0.5f;
    private static final float INCOMPLETE_FILE_RATING = 0.2f;
    private static final SpamManager INSTANCE = new SpamManager();

    public static SpamManager instance() {
        return INSTANCE;
    }

    private SpamManager() {
    }

    public void startedQuery(QueryRequest qr) {
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue()) {
            RatingTable.instance().mark(qr, 5);
        }
    }

    public boolean isSpam(RemoteFileDesc rfd) {
        if (!SearchSettings.ENABLE_SPAM_FILTER.getValue()) {
            return false;
        }
        float rating = 0.0f;
        if (rfd.getSHA1Urn() == null && rfd.getXMLDocument() != null && rfd.getXMLDocument().getAction().length() == 0) {
            rating = 1.0f - (1.0f - rating) * 0.5f;
        }
        if (this.isIncompleteFile(rfd.getFileName().toLowerCase(Locale.US))) {
            rating = 1.0f - (1.0f - rating) * 0.2f;
        }
        rating = 1.0f - (1.0f - rating) * (1.0f - RatingTable.instance().getRating(rfd));
        rfd.setSpamRating(rating);
        return rating >= Math.max(SearchSettings.FILTER_SPAM_RESULTS.getValue(), SearchSettings.QUERY_SPAM_CUTOFF.getValue());
    }

    public void handleUserMarkedSpam(RemoteFileDesc[] rfds) {
        for (int i = 0; i < rfds.length; ++i) {
            rfds[i].setSpamRating(1.0f);
        }
        RatingTable.instance().mark(rfds, 1);
    }

    public void handleUserMarkedGood(RemoteFileDesc[] rfds) {
        for (int i = 0; i < rfds.length; ++i) {
            rfds[i].setSpamRating(0.0f);
        }
        RatingTable.instance().mark(rfds, 3);
    }

    public void clearFilterData() {
        RatingTable.instance().clear();
    }

    private boolean isIncompleteFile(String name) {
        int i;
        if (name.startsWith("__incomplete")) {
            return true;
        }
        if (name.startsWith("___incompleted")) {
            return true;
        }
        if (name.startsWith("___arestra")) {
            return true;
        }
        if (name.startsWith("preview-t-")) {
            return true;
        }
        if (name.startsWith("t-")) {
            for (i = 2; i < name.length(); ++i) {
                if (Character.isDigit(name.charAt(i))) continue;
                return name.charAt(i) == '-';
            }
        }
        if (name.startsWith("corrupt-")) {
            for (i = 8; i < name.length(); ++i) {
                if (Character.isDigit(name.charAt(i))) continue;
                return name.charAt(i) == '-';
            }
        }
        return false;
    }
}

