/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.limegroup.gnutella.spam.AbstractToken;
import java.util.Arrays;

public class XMLKeywordToken
extends AbstractToken {
    private static final long serialVersionUID = 3617573808026760503L;
    public static final int TYPE = 5;
    private static final byte INITAL_GOOD = 20;
    private static final int MAX = 100;
    private final byte[] _keyword;
    private final byte[] _xmlField;
    private byte _good = (byte)90;
    private byte _bad = 0;
    private final int _hashCode;

    XMLKeywordToken(String xmlField, byte[] keyword) {
        this._keyword = keyword;
        this._xmlField = xmlField.getBytes();
        int hash = xmlField.hashCode();
        for (int i = 0; i < keyword.length; ++i) {
            hash = 37 * hash + keyword[i];
        }
        this._hashCode = hash;
    }

    public float getRating() {
        return (float)Math.pow(1.0f * (float)this._bad / (float)(this._good + this._bad + 1), 2.0);
    }

    public void rate(int rating) {
        this._age = 0;
        switch (rating) {
            case 4: {
                this._good = (byte)(this._good + 1);
                break;
            }
            case 2: {
                this._bad = (byte)(this._bad + 1);
                break;
            }
            case 3: {
                this._bad = 0;
                break;
            }
            case 1: {
                this._bad = (byte)Math.min(10 + this._bad, 100);
                break;
            }
            case 5: {
                this._bad = 0;
                this._good = (byte)90;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type of rating");
            }
        }
        if (this._good >= 100 || this._bad >= 100) {
            this._good = (byte)(this._good * 9 / 10);
            this._bad = (byte)(this._bad * 9 / 10);
        }
    }

    public int getType() {
        return 5;
    }

    public final int hashCode() {
        return this._hashCode;
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof XMLKeywordToken)) {
            return false;
        }
        if (this._hashCode != o.hashCode()) {
            return false;
        }
        return Arrays.equals(this._xmlField, ((XMLKeywordToken)o)._xmlField) && Arrays.equals(this._keyword, ((XMLKeywordToken)o)._keyword);
    }

    public String toString() {
        return new String(this._xmlField) + "::" + new String(this._keyword) + " : " + this._good + " : " + this._bad;
    }
}

