/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.statistics;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.statistics.AdvancedKilobytesStatistic;
import com.limegroup.gnutella.statistics.AdvancedStatistic;
import com.limegroup.gnutella.statistics.Statistic;
import com.limegroup.gnutella.statistics.StatisticsManager;

public abstract class AbstractStatHandler {
    public final Statistic NUMBER_STAT;
    public final Statistic BYTE_STAT;
    public final Statistic LIME_NUMBER_STAT;
    public final Statistic LIME_BYTE_STAT;
    public final Statistic BANDWIDTH_BYTE_STAT;
    protected static final StatisticsManager STATS_MANAGER = StatisticsManager.instance();
    private static final Statistic BANDWIDTH_BYTE_STAT_STUB = new AdvancedStatistic(){

        public void addData() {
        }
    };

    protected AbstractStatHandler(String fileName) {
        this.NUMBER_STAT = new AdvancedStatistic(fileName);
        this.BYTE_STAT = new AdvancedKilobytesStatistic(fileName);
        this.LIME_NUMBER_STAT = new AdvancedStatistic(fileName);
        this.LIME_BYTE_STAT = new AdvancedKilobytesStatistic(fileName);
        this.BANDWIDTH_BYTE_STAT = BANDWIDTH_BYTE_STAT_STUB;
    }

    protected AbstractStatHandler(Statistic numberStat, Statistic byteStat, Statistic limeNumberStat, Statistic limeByteStat, Statistic bandwidthByteStat) {
        this.NUMBER_STAT = numberStat;
        this.BYTE_STAT = byteStat;
        this.LIME_NUMBER_STAT = limeNumberStat;
        this.LIME_BYTE_STAT = limeByteStat;
        this.BANDWIDTH_BYTE_STAT = bandwidthByteStat;
    }

    protected AbstractStatHandler(Statistic numberStat, Statistic byteStat, Statistic limeNumberStat, Statistic limeByteStat) {
        this(numberStat, byteStat, limeNumberStat, limeByteStat, BANDWIDTH_BYTE_STAT_STUB);
    }

    public void addMessage(Message msg) {
        this.BANDWIDTH_BYTE_STAT.addData(msg.getTotalLength());
        if (!STATS_MANAGER.getRecordAdvancedStats()) {
            return;
        }
        this.NUMBER_STAT.incrementStat();
        this.BYTE_STAT.addData(msg.getTotalLength());
        if (new GUID(msg.getGUID()).isLimeGUID()) {
            this.LIME_NUMBER_STAT.incrementStat();
            this.LIME_BYTE_STAT.addData(msg.getTotalLength());
        }
    }
}

