/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.limegroup.gnutella.dime.AsyncDimeParser;
import com.limegroup.gnutella.io.ReadState;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeHandler;
import com.limegroup.gnutella.tigertree.ThexReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.List;

public class AsyncHashTreeHandler
extends ReadState
implements ThexReader {
    private String sha1;
    private long fileSize;
    private String root32;
    private AsyncDimeParser parser;

    public AsyncHashTreeHandler(String sha1, long fileSize, String root32) {
        this.sha1 = sha1;
        this.fileSize = fileSize;
        this.root32 = root32;
        this.parser = new AsyncDimeParser();
    }

    protected boolean processRead(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        return this.parser.process(channel, buffer);
    }

    public HashTree getHashTree() throws IOException {
        List records = this.parser.getRecords();
        return new HashTree(HashTreeHandler.nodesFromRecords(records.iterator(), this.fileSize, this.root32), this.sha1, this.fileSize);
    }

    public long getAmountProcessed() {
        return this.parser.getAmountProcessed();
    }
}

