/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.dime.DIMEGenerator;
import com.limegroup.gnutella.dime.DIMEParser;
import com.limegroup.gnutella.dime.DIMERecord;
import com.limegroup.gnutella.tigertree.AsyncHashTreeHandler;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.ThexReader;
import com.limegroup.gnutella.util.UUID;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class HashTreeHandler {
    private static final Log LOG = LogFactory.getLog(HashTreeHandler.class);
    private static final String OUTPUT_TYPE = "application/dime";
    private static final String SERIALIZED_TREE_TYPE = "http://open-content.net/spec/thex/breadthfirst";
    private static final String XML_TYPE = "text/xml";
    private static final byte[] TREE_TYPE_BYTES = HashTreeHandler.getBytes("http://open-content.net/spec/thex/breadthfirst");
    private static final byte[] XML_TYPE_BYTES = HashTreeHandler.getBytes("text/xml");
    private static final String DIGEST = "http://open-content.net/spec/digest/tiger";
    private static final String DTD_PUBLIC_ID = "-//NET//OPEN-CONTENT//THEX 02//EN";
    private static final String DTD_SYSTEM_ID = "http://open-content.net/spec/thex/thex.dtd";
    private static final String DTD_ENTITY = "<!ELEMENT hashtree (file,digest,serializedtree)><!ELEMENT file EMPTY><!ATTLIST file size CDATA #REQUIRED><!ATTLIST file segmentsize CDATA #REQUIRED><!ELEMENT digest EMPTY><!ATTLIST digest algorithm CDATA #REQUIRED><!ATTLIST digest outputsize CDATA #REQUIRED><!ELEMENT serializedtree EMPTY><!ATTLIST serializedtree depth CDATA #REQUIRED><!ATTLIST serializedtree type CDATA #REQUIRED><!ATTLIST serializedtree uri CDATA #REQUIRED>";
    private static final String SYSTEM_STRING = "SYSTEM";
    private static final String XML_TREE_DESC_START = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE hashtree SYSTEM \"http://open-content.net/spec/thex/thex.dtd\"><hashtree>";
    private static final String XML_TREE_DESC_END = "</hashtree>";
    private static int HASH_SIZE = 24;
    private final DIMEGenerator GENERATOR;

    private static byte[] getBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            LOG.debug(string, uee);
            return string.getBytes();
        }
    }

    public HashTreeHandler(HashTree tree) {
        LOG.trace("creating HashTreeHandler for sending");
        UUID uri = UUID.nextUUID();
        this.GENERATOR = new DIMEGenerator();
        this.GENERATOR.add(new XMLRecord(tree, uri));
        this.GENERATOR.add(new TreeRecord(tree, uri));
    }

    public void write(OutputStream os) throws IOException {
        this.GENERATOR.write(os);
    }

    public int getLength() {
        return this.GENERATOR.getLength();
    }

    public String getType() {
        return OUTPUT_TYPE;
    }

    static ThexReader createAsyncReader(String sha1, long fileSize, String root32) {
        return new AsyncHashTreeHandler(sha1, fileSize, root32);
    }

    static List read(InputStream is, long fileSize, String root32) throws IOException {
        LOG.trace("creating HashTreeHandler from network");
        DIMEParser parser = new DIMEParser(is);
        return HashTreeHandler.nodesFromRecords(parser, fileSize, root32);
    }

    static List nodesFromRecords(Iterator iterator, long fileSize, String root32) throws IOException {
        if (!iterator.hasNext()) {
            throw new IOException("no xml record");
        }
        DIMERecord xmlRecord = (DIMERecord)iterator.next();
        if (!iterator.hasNext()) {
            throw new IOException("no tree record");
        }
        DIMERecord treeRecord = (DIMERecord)iterator.next();
        if (LOG.isDebugEnabled()) {
            LOG.debug("xml id: [" + xmlRecord.getIdentifier() + "]");
            LOG.debug("xml type: [" + xmlRecord.getTypeString() + "]");
            LOG.debug("tree id: [" + treeRecord.getIdentifier() + "]");
            LOG.debug("tree type: [" + treeRecord.getTypeString() + "]");
            LOG.debug("xml type num: [" + xmlRecord.getTypeId() + "]");
            LOG.debug("tree type num: [" + treeRecord.getTypeId() + "]");
        }
        while (iterator.hasNext()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("more elements in the dime record.");
            }
            iterator.next();
        }
        String xml = new String(xmlRecord.getData(), "UTF-8");
        byte[] hashTree = treeRecord.getData();
        XMLTreeDescription xtd = new XMLTreeDescription(xml);
        if (!xtd.isValid()) {
            throw new IOException("invalid XMLTreeDescription " + xtd.toString());
        }
        if (xtd.getFileSize() != fileSize) {
            throw new IOException("file size attribute was " + xtd.getFileSize() + " expected " + fileSize);
        }
        HashTreeDescription htr = new HashTreeDescription(hashTree);
        if (!Base32.encode(htr.getRoot()).equals(root32)) {
            throw new IOException("Root hashes do not match");
        }
        return htr.getAllNodes(fileSize);
    }

    private static class HashTreeDescription {
        private final byte[] DATA;

        protected HashTreeDescription(byte[] data) {
            this.DATA = data;
        }

        byte[] getRoot() throws IOException {
            if (this.DATA.length < HASH_SIZE) {
                throw new IOException("invalid data");
            }
            byte[] ret = new byte[HASH_SIZE];
            System.arraycopy(this.DATA, 0, ret, 0, HASH_SIZE);
            return ret;
        }

        List getAllNodes(long fileSize) throws IOException {
            int depth = HashTree.calculateDepth(fileSize);
            ArrayList<byte[]> hashes = new ArrayList<byte[]>();
            byte[] data = this.DATA;
            if (data.length % HASH_SIZE != 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("illegal size of data field for HashTree");
                }
                throw new IOException("corrupted hash tree detected");
            }
            int i = 0;
            while (i + HASH_SIZE <= data.length) {
                byte[] hash = new byte[HASH_SIZE];
                System.arraycopy(data, i, hash, 0, HASH_SIZE);
                hashes.add(hash);
                i += HASH_SIZE;
            }
            String root32 = Base32.encode(this.getRoot());
            Iterator hashIterator = hashes.iterator();
            ArrayList<byte[]> generation = new ArrayList<byte[]>(1);
            ArrayList<byte[]> parent = null;
            int genIndex = 0;
            boolean verified = false;
            ArrayList allNodes = new ArrayList(depth + 1);
            while (genIndex <= depth && hashIterator.hasNext()) {
                List calculatedParent;
                verified = false;
                byte[] hash = (byte[])hashIterator.next();
                generation.add(hash);
                if (parent == null) {
                    verified = true;
                    ++genIndex;
                    parent = generation;
                    allNodes.add(generation);
                    generation = new ArrayList(2);
                    continue;
                }
                if (generation.size() > parent.size() * 2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("parent");
                        String str = "";
                        Iterator iter = parent.iterator();
                        while (iter.hasNext()) {
                            str = str + Base32.encode((byte[])iter.next()) + "; ";
                        }
                        LOG.debug(str);
                        str = "";
                        LOG.debug("newparent");
                        List newparent = HashTree.createParentGeneration(generation);
                        Iterator iter2 = newparent.iterator();
                        while (iter2.hasNext()) {
                            str = str + Base32.encode((byte[])iter2.next()) + "; ";
                        }
                        LOG.debug(str);
                        str = "";
                        LOG.debug("generation");
                        iter2 = generation.iterator();
                        while (iter2.hasNext()) {
                            str = str + Base32.encode((byte[])iter2.next()) + "; ";
                        }
                        LOG.debug(str);
                        str = "";
                    }
                    throw new IOException("corrupted hash tree detected");
                }
                if (generation.size() != parent.size() * 2 - 1 && generation.size() != parent.size() * 2 || !this.isMatching(parent, calculatedParent = HashTree.createParentGeneration(generation))) continue;
                parent = generation;
                allNodes.add(Collections.unmodifiableList(generation));
                if (++genIndex <= depth && hashIterator.hasNext()) {
                    generation = new ArrayList(parent.size() * 2);
                }
                verified = true;
            }
            if (!verified) {
                throw new IOException("corrupted hash tree detected");
            }
            LOG.debug("Valid hash tree received.");
            return allNodes;
        }

        private boolean isMatching(List a, List b) {
            if (a.size() == b.size()) {
                for (int i = 0; i < a.size(); ++i) {
                    byte[] two;
                    byte[] one = (byte[])a.get(i);
                    if (Arrays.equals(one, two = (byte[])b.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static final class Resolver
    implements EntityResolver {
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId.equals(HashTreeHandler.DTD_SYSTEM_ID)) {
                InputSource is = new InputSource(new StringReader(HashTreeHandler.DTD_ENTITY));
                is.setPublicId(HashTreeHandler.DTD_PUBLIC_ID);
                is.setSystemId(HashTreeHandler.DTD_SYSTEM_ID);
                return is;
            }
            if (publicId == null) {
                throw new SAXException("Can't resolve SYSTEM entity at '" + systemId + "'");
            }
            throw new SAXException("Can't resolve PUBLIC entity '" + publicId + "' at '" + systemId + "'");
        }
    }

    private static class XMLTreeDescription {
        private static final int UNKNOWN = 0;
        private static final int VALID = 1;
        private static final int INVALID = 2;
        private int _parsed = 0;
        private long _fileSize = 0L;
        private int _blockSize = 0;
        private String _algorithm = null;
        private int _hashSize = 0;
        private String _serializationType = null;
        private String _uri;
        private String data;

        protected XMLTreeDescription(String xml) {
            this.data = xml;
        }

        long getFileSize() {
            return this._fileSize;
        }

        String getURI() {
            return this._uri;
        }

        boolean isValid() {
            if (this._parsed == 0) {
                int n = this._parsed = this.parse() ? 1 : 2;
            }
            if (this._parsed == 2) {
                return false;
            }
            if (this._blockSize != 1024) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unexpected block size: " + this._blockSize);
                }
                return false;
            }
            if (!HashTreeHandler.DIGEST.equals(this._algorithm)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unsupported digest algorithm: " + this._algorithm);
                }
                return false;
            }
            if (this._hashSize != HASH_SIZE) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unexpected block size: " + this._blockSize);
                }
                return false;
            }
            if (!HashTreeHandler.SERIALIZED_TREE_TYPE.equals(this._serializationType)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unexpected serialization type: " + this._serializationType);
                }
                return false;
            }
            return true;
        }

        private boolean parse() {
            int offset = this.data.indexOf("system");
            if (offset > 0 && offset < this.data.indexOf(HashTreeHandler.DTD_SYSTEM_ID)) {
                this.data = this.data.substring(0, offset) + HashTreeHandler.SYSTEM_STRING + this.data.substring(offset + "system".length());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("XMLTreeDescription read: " + this.data);
            }
            DOMParser parser = new DOMParser();
            InputSource is = new InputSource(new StringReader(this.data));
            parser.setEntityResolver(new Resolver());
            try {
                parser.parse(is);
            }
            catch (IOException ioe) {
                LOG.debug(ioe);
                return false;
            }
            catch (SAXException saxe) {
                LOG.debug(saxe);
                return false;
            }
            Document doc = parser.getDocument();
            Node treeDesc = doc.getElementsByTagName("hashtree").item(0);
            if (treeDesc == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("couldn't find hashtree element: " + this.data);
                }
                return false;
            }
            NodeList nodes = treeDesc.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                if (el.getTagName().equals("file")) {
                    this.parseFileElement(el);
                    continue;
                }
                if (el.getTagName().equals("digest")) {
                    this.parseDigestElement(el);
                    continue;
                }
                if (!el.getTagName().equals("serializedtree")) continue;
                this.parseSerializedtreeElement(el);
            }
            return true;
        }

        private void parseFileElement(Element e) {
            block5: {
                block4: {
                    try {
                        this._fileSize = Long.parseLong(e.getAttribute("size"));
                    }
                    catch (NumberFormatException nfe) {
                        if (!LOG.isDebugEnabled()) break block4;
                        LOG.debug("couldn't parse file size: " + e.getNodeValue(), nfe);
                    }
                }
                try {
                    this._blockSize = Integer.parseInt(e.getAttribute("segmentsize"));
                }
                catch (NumberFormatException nfe) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug("couldn't parse block size: " + e.getNodeValue(), nfe);
                }
            }
        }

        private void parseDigestElement(Element e) {
            block2: {
                this._algorithm = e.getAttribute("algorithm");
                try {
                    this._hashSize = Integer.parseInt(e.getAttribute("outputsize"));
                }
                catch (NumberFormatException nfe) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("couldn't parse hash size: " + e.getNodeValue(), nfe);
                }
            }
        }

        private void parseSerializedtreeElement(Element e) {
            block2: {
                this._serializationType = e.getAttribute("type");
                this._uri = e.getAttribute("uri");
                try {
                    Integer.parseInt(e.getAttribute("depth"));
                }
                catch (NumberFormatException nfe) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("couldn't parse depth: " + e.getNodeValue(), nfe);
                }
            }
        }
    }

    private static class TreeRecord
    extends DIMERecord {
        private final HashTree TREE;
        private final int LENGTH;

        TreeRecord(HashTree tree, UUID uri) {
            super((byte)32, null, HashTreeHandler.getBytes("uuid:" + uri), TREE_TYPE_BYTES, null);
            this.TREE = tree;
            this.LENGTH = this.TREE.getNodeCount() * HASH_SIZE;
        }

        public void writeData(OutputStream out) throws IOException {
            Iterator i = this.TREE.getAllNodes().iterator();
            while (i.hasNext()) {
                Iterator iter = ((List)i.next()).iterator();
                while (iter.hasNext()) {
                    out.write((byte[])iter.next());
                }
            }
            TreeRecord.writePadding(this.getDataLength(), out);
        }

        public int getDataLength() {
            return this.LENGTH;
        }
    }

    private static class XMLRecord
    extends DIMERecord {
        XMLRecord(HashTree tree, UUID uri) {
            super((byte)16, null, null, XML_TYPE_BYTES, XMLRecord.getXML(tree, uri));
        }

        private static byte[] getXML(HashTree tree, UUID uri) {
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE hashtree SYSTEM \"http://open-content.net/spec/thex/thex.dtd\"><hashtree><file size='" + tree.getFileSize() + "' segmentsize='" + 1024 + "'/>" + "<digest algorithm='" + HashTreeHandler.DIGEST + "' outputsize='" + HASH_SIZE + "'/>" + "<serializedtree depth='" + tree.getDepth() + "' type='" + HashTreeHandler.SERIALIZED_TREE_TYPE + "' uri='uuid:" + uri + "'/>" + HashTreeHandler.XML_TREE_DESC_END;
            return HashTreeHandler.getBytes(xml);
        }
    }
}

