/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;

public class AckMessage
extends UDPConnectionMessage {
    private long _windowStart;
    private int _windowSpace;

    public AckMessage(byte connectionID, long sequenceNumber, long windowStart, int windowSpace) {
        super(connectionID, (byte)1, sequenceNumber, AckMessage.buildByteArray((int)windowStart & 0xFFFF, windowSpace < 0 ? 0 : windowSpace), 4);
        this._windowStart = windowStart;
        this._windowSpace = windowSpace;
    }

    public AckMessage(byte[] guid, byte ttl, byte hops, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, payload);
        this._windowStart = AckMessage.getShortInt(guid[4], guid[5]);
        this._windowSpace = AckMessage.getShortInt(guid[6], guid[7]);
    }

    public long getWindowStart() {
        return this._windowStart;
    }

    public void extendWindowStart(long wStart) {
        this._windowStart = wStart;
    }

    public int getWindowSpace() {
        return this._windowSpace;
    }

    public String toString() {
        return "AckMessage DestID:" + this.getConnectionID() + " start:" + this._windowStart + " space:" + this._windowSpace + " seq:" + this.getSequenceNumber();
    }
}

