/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;
import java.nio.ByteBuffer;

public class DataMessage
extends UDPConnectionMessage {
    public static final int MAX_DATA = 512;
    private final ByteBuffer chunk;

    public DataMessage(byte connectionID, long sequenceNumber, ByteBuffer chunk) {
        super(connectionID, (byte)3, sequenceNumber, chunk.array(), chunk.remaining());
        this.chunk = chunk;
    }

    public DataMessage(byte connectionID, long sequenceNumber, byte[] data, int len) {
        super(connectionID, (byte)3, sequenceNumber, data, len);
        this.chunk = null;
    }

    ByteBuffer getChunk() {
        return this.chunk;
    }

    public DataMessage(byte[] guid, byte ttl, byte hops, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, payload);
        this.chunk = null;
    }

    public ByteBuffer getData1Chunk() {
        return this._data1;
    }

    public ByteBuffer getData2Chunk() {
        return this._data2;
    }

    public byte getDataAt(int i) {
        if (i < 12) {
            return this._data1.get(i + this._data1.position());
        }
        return this._data2.get(i - 12 + this._data2.position());
    }

    public String toString() {
        return "DataMessage DestID:" + this.getConnectionID() + " len:" + this.getDataLength() + " seq:" + this.getSequenceNumber();
    }
}

