/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.io.AbstractNBSocket;
import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.udpconnect.UDPSelectorProvider;
import com.limegroup.gnutella.udpconnect.UDPSocketChannel;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;

public class UDPConnection
extends AbstractNBSocket {
    public static final byte VERSION = 1;
    private final UDPSocketChannel channel = (UDPSocketChannel)UDPSelectorProvider.instance().openSocketChannel();
    private int soTimeout = 60000;

    public UDPConnection() {
        this.channel.setSocket(this);
        this.setInitialReader();
        this.setInitialWriter();
    }

    public UDPConnection(String ip, int port) throws IOException {
        this(InetAddress.getByName(ip), port);
    }

    public UDPConnection(InetAddress ip, int port) throws IOException {
        this();
        this.connect(new InetSocketAddress(ip, port));
    }

    protected InterestReadChannel getBaseReadChannel() {
        return this.channel;
    }

    protected InterestWriteChannel getBaseWriteChannel() {
        return this.channel;
    }

    protected void shutdownImpl() {
    }

    public void setSoTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public InetAddress getLocalAddress() {
        InetAddress lip = null;
        try {
            lip = InetAddress.getByName(NetworkUtils.ip2string(RouterService.getNonForcedAddress()));
        }
        catch (UnknownHostException uhe) {
            try {
                lip = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe2) {
                lip = null;
            }
        }
        return lip;
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.channel.getRemoteSocketAddress();
    }

    public InetAddress getInetAddress() {
        return ((InetSocketAddress)this.getRemoteSocketAddress()).getAddress();
    }

    public int getPort() {
        return ((InetSocketAddress)this.getRemoteSocketAddress()).getPort();
    }

    public int getLocalPort() {
        return UDPService.instance().getStableUDPPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public String toString() {
        return "UDPConnection:" + this.channel;
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public boolean isBound() {
        return true;
    }

    public boolean isClosed() {
        return !this.channel.isOpen();
    }

    public boolean isInputShutdown() {
        return !this.channel.isOpen();
    }

    public boolean isOutputShutdown() {
        return !this.channel.isOpen();
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        throw new IOException("not implemented");
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
    }

    public boolean getTcpNoDelay() throws SocketException {
        return true;
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
    }

    public int getSoLinger() throws SocketException {
        return -1;
    }

    public void sendUrgentData(int data) throws IOException {
        throw new IOException("not implemented");
    }

    public void setOOBInline(boolean on) throws SocketException {
        throw new SocketException("not implemented");
    }

    public boolean getOOBInline() throws SocketException {
        throw new SocketException("not implemented");
    }

    public synchronized void setSendBufferSize(int size) throws SocketException {
        throw new SocketException("not implemented");
    }

    public synchronized int getSendBufferSize() throws SocketException {
        throw new SocketException("not implemented");
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        throw new SocketException("not implemented");
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        throw new SocketException("not implemented");
    }

    public void setKeepAlive(boolean on) throws SocketException {
    }

    public boolean getKeepAlive() throws SocketException {
        return true;
    }

    public void setTrafficClass(int tc) throws SocketException {
        throw new SocketException("not implemented");
    }

    public int getTrafficClass() throws SocketException {
        throw new SocketException("not implemented");
    }

    public void setReuseAddress(boolean on) throws SocketException {
        throw new SocketException("not implemented");
    }

    public boolean getReuseAddress() throws SocketException {
        throw new SocketException("not implemented");
    }

    public void shutdownInput() throws IOException {
        throw new SocketException("not implemented");
    }

    public void shutdownOutput() throws IOException {
        throw new IOException("not implemented");
    }
}

