/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.udpconnect.SynMessage;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;
import com.limegroup.gnutella.udpconnect.UDPSelectionKey;
import com.limegroup.gnutella.udpconnect.UDPSocketChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPMultiplexor
extends AbstractSelector {
    private static final Log LOG = LogFactory.getLog(UDPMultiplexor.class);
    public static final byte UNASSIGNED_SLOT = 0;
    private volatile UDPSocketChannel[] _channels;
    private final List channelsToRemove = new LinkedList();
    private Set selectedKeys = new HashSet(256);
    private int _lastConnectionID = 0;

    UDPMultiplexor(SelectorProvider provider) {
        super(provider);
        this._channels = new UDPSocketChannel[256];
    }

    public boolean isConnectedTo(InetAddress host) {
        UDPSocketChannel[] array = this._channels;
        if (this._lastConnectionID == 0) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            UDPSocketChannel channel = array[i];
            if (channel == null || !host.equals(channel.getRemoteSocketAddress().getAddress())) continue;
            return true;
        }
        return false;
    }

    public void routeMessage(UDPConnectionMessage msg, InetSocketAddress addr) {
        UDPSocketChannel channel;
        UDPSocketChannel[] array = this._channels;
        int connID = msg.getConnectionID() & 0xFF;
        if (connID == 0 && msg instanceof SynMessage) {
            for (int i = 1; i < array.length; ++i) {
                UDPSocketChannel channel2 = array[i];
                if (channel2 == null || !channel2.isConnectionPending() || !channel2.getRemoteSocketAddress().equals(addr)) continue;
                channel2.getProcessor().handleMessage(msg);
                break;
            }
        } else if (array[connID] != null && (channel = array[connID]).getRemoteSocketAddress().equals(addr)) {
            channel.getProcessor().handleMessage(msg);
        }
    }

    protected void implCloseSelector() throws IOException {
        throw new IllegalStateException("should never be closed.");
    }

    protected synchronized SelectionKey register(AbstractSelectableChannel ch, int ops, Object att) {
        int i;
        if (!(ch instanceof UDPSocketChannel)) {
            throw new IllegalSelectorException();
        }
        UDPSocketChannel channel = (UDPSocketChannel)ch;
        UDPSocketChannel[] copy = new UDPSocketChannel[this._channels.length];
        for (i = 0; i < this._channels.length; ++i) {
            copy[i] = this._channels[i];
        }
        for (i = 1; i <= copy.length; ++i) {
            int connID = (this._lastConnectionID + i) % 256;
            if (connID == 0 || copy[connID] != null) continue;
            this._lastConnectionID = connID;
            copy[connID] = channel;
            channel.getProcessor().setConnectionId((byte)connID);
            this._channels = copy;
            return new UDPSelectionKey(this, att, ch, ops);
        }
        LOG.warn("Attempting to add over connection limit");
        this.channelsToRemove.add(ch);
        return new UDPSelectionKey(this, att, ch, ops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keys() {
        UDPSocketChannel[] channels = this._channels;
        HashSet<SelectionKey> keys = new HashSet<SelectionKey>();
        for (int i = 0; i < channels.length; ++i) {
            if (channels[i] == null) continue;
            keys.add(channels[i].keyFor(this));
        }
        UDPMultiplexor uDPMultiplexor = this;
        synchronized (uDPMultiplexor) {
            Iterator i = this.channelsToRemove.iterator();
            while (i.hasNext()) {
                keys.add(((SelectableChannel)i.next()).keyFor(this));
            }
        }
        return keys;
    }

    public int select() throws IOException {
        throw new UnsupportedOperationException("blocking select not supported");
    }

    public int select(long timeout) throws IOException {
        throw new UnsupportedOperationException("blocking select not supported");
    }

    public Set selectedKeys() {
        return this.selectedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int selectNow() throws IOException {
        UDPSocketChannel[] array = this._channels;
        UDPSocketChannel[] removed = null;
        this.selectedKeys.clear();
        for (int i = 0; i < array.length; ++i) {
            UDPSelectionKey key;
            UDPSocketChannel channel = array[i];
            if (channel == null || (key = (UDPSelectionKey)channel.keyFor(this)) == null) continue;
            if (key.isValid()) {
                int currentOps = channel.getProcessor().readyOps();
                int readyOps = currentOps & key.interestOps();
                if (readyOps == 0) continue;
                key.setReadyOps(readyOps);
                this.selectedKeys.add(key);
                continue;
            }
            if (removed == null) {
                removed = new UDPSocketChannel[array.length];
            }
            removed[i] = channel;
        }
        UDPMultiplexor uDPMultiplexor = this;
        synchronized (uDPMultiplexor) {
            if (removed != null) {
                UDPSocketChannel[] copy = new UDPSocketChannel[this._channels.length];
                for (int i = 0; i < this._channels.length; ++i) {
                    copy[i] = this._channels[i] == removed[i] ? null : this._channels[i];
                }
                this._channels = copy;
            }
            if (!this.channelsToRemove.isEmpty()) {
                Iterator i = this.channelsToRemove.iterator();
                while (i.hasNext()) {
                    SelectableChannel next = (SelectableChannel)i.next();
                    UDPSelectionKey key = (UDPSelectionKey)next.keyFor(this);
                    key.cancel();
                    key.setReadyOps(0);
                    this.selectedKeys.add(key);
                }
                this.channelsToRemove.clear();
            }
        }
        return this.selectedKeys.size();
    }

    public Selector wakeup() {
        return this;
    }
}

