/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.io.BufferUtils;
import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.WriteObserver;
import com.limegroup.gnutella.udpconnect.ChunkReleaser;
import com.limegroup.gnutella.udpconnect.DataMessage;
import com.limegroup.gnutella.udpconnect.DataRecord;
import com.limegroup.gnutella.udpconnect.DataWindow;
import com.limegroup.gnutella.udpconnect.UDPConnectionProcessor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;

class UDPSocketChannel
extends SocketChannel
implements InterestReadChannel,
InterestWriteChannel,
ChunkReleaser {
    private final UDPConnectionProcessor processor;
    private Socket socket;
    private final DataWindow readData;
    private volatile WriteObserver writer;
    private ArrayList chunks;
    private ByteBuffer activeChunk;
    private boolean writeHandled = false;
    private final Object writeLock = new Object();
    private boolean shutdown = false;

    UDPSocketChannel(SelectorProvider provider) {
        super(provider);
        this.processor = new UDPConnectionProcessor(this);
        this.readData = this.processor.getReadWindow();
        this.chunks = new ArrayList(5);
        this.allocateNewChunk();
        try {
            this.configureBlocking(false);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    UDPSocketChannel(UDPConnectionProcessor processor) {
        super(null);
        this.processor = processor;
        this.readData = processor.getReadWindow();
        this.chunks = new ArrayList(5);
        this.allocateNewChunk();
        try {
            this.configureBlocking(false);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    UDPConnectionProcessor getProcessor() {
        return this.processor;
    }

    public void interest(boolean status) {
        NIODispatcher.instance().interestRead(this, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer to) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        UDPConnectionProcessor uDPConnectionProcessor = this.processor;
        synchronized (uDPConnectionProcessor) {
            int read = 0;
            DataRecord currentRecord = this.readData.getReadableBlock();
            while (currentRecord != null) {
                read += this.transfer(currentRecord, to);
                if (!to.hasRemaining()) break;
                currentRecord = this.readData.getReadableBlock();
            }
            int priorSpace = this.readData.getWindowSpace();
            this.readData.clearEarlyReadBlocks();
            if (priorSpace == 0 && read > 0 || (long)priorSpace <= 2L && (long)this.readData.getWindowSpace() > 2L) {
                this.processor.sendKeepAlive();
            }
            if (read == 0 && this.processor.isClosed()) {
                return -1;
            }
            return read;
        }
    }

    private int transfer(DataRecord record, ByteBuffer to) {
        DataMessage msg = record.msg;
        int read = 0;
        ByteBuffer chunk = msg.getData1Chunk();
        if (chunk.hasRemaining()) {
            read += BufferUtils.transfer(chunk, to, false);
        }
        if (chunk.hasRemaining()) {
            return read;
        }
        chunk = msg.getData2Chunk();
        read += BufferUtils.transfer(chunk, to, false);
        if (!chunk.hasRemaining()) {
            record.read = true;
        }
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src) throws IOException {
        if (!this.isOpen() || this.processor.isClosed()) {
            throw new ClosedChannelException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            if (this.getNumberOfPendingChunks() == 0) {
                this.processor.wakeupWriteEvent(!this.writeHandled);
            }
            this.writeHandled = true;
            int wrote = 0;
            while (src.hasRemaining()) {
                if (this.activeChunk.hasRemaining()) {
                    wrote += BufferUtils.transfer(src, this.activeChunk, false);
                    continue;
                }
                if (this.chunks.size() < this.processor.getChunkLimit()) {
                    this.chunks.add(this.activeChunk);
                    this.allocateNewChunk();
                    continue;
                }
                return wrote;
            }
            return wrote;
        }
    }

    private void allocateNewChunk() {
        this.activeChunk = NIODispatcher.instance().getBufferCache().getHeap(512);
    }

    public void releaseChunk(ByteBuffer chunk) {
        NIODispatcher.instance().getBufferCache().release(chunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer getNextChunk() {
        Object object = this.writeLock;
        synchronized (object) {
            ByteBuffer rChunk;
            if (this.chunks.size() > 0) {
                rChunk = (ByteBuffer)this.chunks.remove(0);
                rChunk.flip();
            } else if (this.activeChunk.position() > 0) {
                rChunk = this.activeChunk;
                rChunk.flip();
                this.allocateNewChunk();
            } else {
                rChunk = null;
            }
            return rChunk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfPendingChunks() {
        Object object = this.writeLock;
        synchronized (object) {
            int count = this.chunks.size();
            if (this.activeChunk.position() > 0) {
                ++count;
            }
            return count;
        }
    }

    Object writeLock() {
        return this.writeLock;
    }

    protected void implCloseSelectableChannel() throws IOException {
        this.processor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        UDPSocketChannel uDPSocketChannel = this;
        synchronized (uDPSocketChannel) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        try {
            this.close();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        WriteObserver chain = this.writer;
        if (chain != null) {
            chain.shutdown();
        }
        this.writer = null;
    }

    public void interest(WriteObserver observer, boolean status) {
        if (this.isOpen()) {
            this.writer = observer;
            NIODispatcher.instance().interestWrite(this, status);
        }
    }

    public boolean handleWrite() throws IOException {
        WriteObserver chain = this.writer;
        if (chain != null) {
            return chain.handleWrite();
        }
        return false;
    }

    public void handleIOException(IOException iox) {
        throw new UnsupportedOperationException();
    }

    public InetSocketAddress getRemoteSocketAddress() {
        return this.processor.getSocketAddress();
    }

    public boolean connect(SocketAddress remote) throws IOException {
        this.processor.connect((InetSocketAddress)remote);
        return false;
    }

    public boolean finishConnect() throws IOException {
        return this.processor.prepareOpenConnection();
    }

    public boolean isConnected() {
        return this.processor.isConnected();
    }

    public boolean isConnectionPending() {
        return this.processor.isConnecting();
    }

    public Socket socket() {
        return this.socket;
    }

    void setSocket(Socket socket) {
        this.socket = socket;
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new IOException("unsupported");
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new IOException("unsupported");
    }

    protected void implConfigureBlocking(boolean block) throws IOException {
    }
}

