/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.updates;

import com.limegroup.gnutella.util.CommonUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class MacAddressFinder {
    String getMacAddress() {
        try {
            if (CommonUtils.isWindows()) {
                return this.getWindowsMac();
            }
            if (CommonUtils.isMacOSX()) {
                return this.getOSXMac();
            }
            if (CommonUtils.isSolaris()) {
                return this.getSolarisMac();
            }
            if (!CommonUtils.isLinux()) {
                return null;
            }
            this.getLinuxMac();
        }
        catch (IOException iox) {
            return null;
        }
        return null;
    }

    private String getWindowsMac() throws IOException {
        String result = this.runCommand("ipconfig /all");
        return this.parseResult(result, ":");
    }

    private String getOSXMac() throws IOException {
        String result = this.runCommand("ifconfig -a");
        return this.parseResult(result, "ether");
    }

    private String getLinuxMac() throws IOException {
        String result = this.runCommand("LANG=C /sbin/ifconfig");
        if (result.length() < 17) {
            result = this.runCommand("LANG=C /bin/ifconfig");
        }
        if (result.length() < 17) {
            result = this.runCommand("LANG=C ifconfig");
        }
        return this.parseResult(result, "hwaddr");
    }

    private String getSolarisMac() throws IOException {
        String result = this.runCommand("ifconfig -a");
        return this.parseResult(result, "ether");
    }

    private String parseResult(String result, String delimiter) {
        result = result.toLowerCase();
        StringTokenizer tok = new StringTokenizer(result, "\n");
        while (tok.hasMoreTokens()) {
            String line = tok.nextToken();
            int index = line.indexOf(delimiter);
            if (index < 0) continue;
            String address = line.substring(index + delimiter.length()).trim();
            if ((address = this.canonicalizeMacAddress(address)) == null) continue;
            return address;
        }
        return null;
    }

    private String canonicalizeMacAddress(String address) {
        if (address.length() != 17) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(address, ":.-");
        for (int i = 0; i < 6; ++i) {
            String val = null;
            try {
                val = tok.nextToken();
                if (val.length() != 2) {
                    return null;
                }
            }
            catch (NoSuchElementException nsex) {
                return null;
            }
            ret.append(val);
            if (i >= 5) continue;
            ret.append("-");
        }
        return ret.toString();
    }

    private String runCommand(String command) throws IOException {
        int c;
        Process process = Runtime.getRuntime().exec(command);
        BufferedInputStream iStream = new BufferedInputStream(process.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)iStream).read()) != -1) {
            buffer.append((char)c);
        }
        ((InputStream)iStream).close();
        return buffer.toString();
    }

    public static void main(String[] args) {
        MacAddressFinder f = new MacAddressFinder();
        System.out.println("The mac address is " + f.getMacAddress());
    }
}

