/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.updates;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.security.SignatureVerifier;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.security.PublicKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateMessageVerifier {
    private static final Log LOG = LogFactory.getLog(UpdateMessageVerifier.class);
    private byte[] data;
    private byte[] signature;
    private byte[] xmlMessage;
    private boolean fromDisk;

    public UpdateMessageVerifier(byte[] fromStream, boolean fromDisk) {
        if (fromStream == null) {
            throw new IllegalArgumentException();
        }
        this.data = fromStream;
        this.fromDisk = fromDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean verifySource() {
        PublicKey pubKey;
        block21: {
            IOException e222;
            ObjectInputStream ois;
            FileInputStream fis;
            block18: {
                boolean parsed = this.parse();
                if (!parsed) {
                    return false;
                }
                pubKey = null;
                fis = null;
                ois = null;
                File file = new File(CommonUtils.getUserSettingsDir(), "public.key");
                fis = new FileInputStream(file);
                ois = new ObjectInputStream(fis);
                pubKey = (PublicKey)ois.readObject();
                Object var8_7 = null;
                if (ois == null) break block18;
                try {
                    ois.close();
                }
                catch (IOException e222) {
                    // empty catch block
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e222) {}
            }
            break block21;
            {
                catch (Throwable t) {
                    IOException e222;
                    LOG.error("Unable to read public key", t);
                    boolean bl = false;
                    Object var8_8 = null;
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                IOException e222;
                Object var8_9 = null;
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        SignatureVerifier verifier = new SignatureVerifier(this.xmlMessage, this.signature, pubKey, "DSA");
        return verifier.verifySignature();
    }

    private boolean parse() {
        int i = this.findPipe(0);
        int j = this.findPipe(i + 1);
        if (i < 0 || j < 0) {
            return false;
        }
        if (this.data.length - j < 10) {
            return false;
        }
        byte[] temp = new byte[i];
        System.arraycopy(this.data, 0, temp, 0, i);
        String base32 = null;
        try {
            base32 = new String(temp, "UTF-8");
        }
        catch (UnsupportedEncodingException usx) {
            ErrorService.error(usx);
        }
        this.signature = Base32.decode(base32);
        this.xmlMessage = new byte[this.data.length - 1 - j];
        System.arraycopy(this.data, j + 1, this.xmlMessage, 0, this.data.length - 1 - j);
        return true;
    }

    private int findPipe(int startIndex) {
        int i;
        int b = -1;
        boolean found = false;
        for (i = startIndex; i < this.data.length; ++i) {
            if (this.data[i] != 124) continue;
            found = true;
            break;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    public byte[] getMessageBytes() throws IllegalStateException {
        if (this.xmlMessage == null) {
            throw new IllegalStateException();
        }
        return this.xmlMessage;
    }
}

