/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class CircularByteBuffer {
    private final ByteBuffer in;
    private final ByteBuffer out;
    private boolean lastOut = true;

    public CircularByteBuffer(int capacity, boolean direct) {
        this.in = direct ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        this.out = this.in.duplicate();
    }

    public final int remainingIn() {
        int o;
        int i = this.in.position();
        if (i > (o = this.out.position())) {
            return this.in.capacity() - i + o;
        }
        if (i < o) {
            return o - i;
        }
        return this.lastOut ? this.in.capacity() : 0;
    }

    public final int remainingOut() {
        return this.in.capacity() - this.remainingIn();
    }

    public void put(ByteBuffer src) {
        if (src.remaining() > this.remainingIn()) {
            throw new BufferOverflowException();
        }
        if (src.remaining() > this.in.remaining()) {
            int oldLimit = src.limit();
            src.limit(src.position() + this.in.remaining());
            this.in.put(src);
            this.in.rewind();
            src.limit(oldLimit);
        }
        this.in.put(src);
        this.lastOut = false;
    }

    public void put(CircularByteBuffer src) {
        if (src.remainingOut() > this.remainingIn()) {
            throw new BufferOverflowException();
        }
        if (this.in.remaining() < src.remainingOut()) {
            src.out.limit(this.in.remaining());
            this.in.put(src.out);
            this.in.rewind();
            src.out.limit(src.out.capacity());
        }
        this.in.put(src.out);
        this.lastOut = false;
    }

    public byte get() {
        if (this.remainingOut() < 1) {
            throw new BufferUnderflowException();
        }
        if (!this.out.hasRemaining()) {
            this.out.rewind();
        }
        this.lastOut = true;
        return this.out.get();
    }

    public void get(byte[] dest) {
        this.get(dest, 0, dest.length);
    }

    public void get(byte[] dest, int offset, int length) {
        if (this.remainingOut() < length) {
            throw new BufferUnderflowException();
        }
        if (this.out.remaining() < length) {
            int remaining = this.out.remaining();
            this.out.get(dest, offset, remaining);
            offset += remaining;
            length -= remaining;
            this.out.rewind();
        }
        this.out.get(dest, offset, length);
        this.lastOut = true;
    }

    public void get(ByteBuffer dest) {
        if (this.remainingOut() < dest.remaining()) {
            throw new BufferUnderflowException();
        }
        if (this.out.remaining() < dest.remaining()) {
            dest.put(this.out);
            this.out.rewind();
        }
        dest.put(this.out);
        this.lastOut = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(WritableByteChannel sink) throws IOException {
        int written = 0;
        int thisTime = 0;
        while (this.remainingOut() > 0) {
            Object var6_5;
            if (!this.out.hasRemaining()) {
                this.out.rewind();
            }
            if (this.in.position() > this.out.position()) {
                this.out.limit(this.in.position());
            }
            int pos = this.out.position();
            try {
                thisTime = sink.write(this.out);
                var6_5 = null;
            }
            catch (Throwable throwable) {
                var6_5 = null;
                if (this.out.position() > pos) {
                    this.lastOut = true;
                }
                throw throwable;
            }
            if (this.out.position() > pos) {
                this.lastOut = true;
            }
            this.out.limit(this.out.capacity());
            if (thisTime == 0) break;
            written += thisTime;
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ReadableByteChannel source) throws IOException {
        int read = 0;
        int thisTime = 0;
        while (this.remainingIn() > 0) {
            Object var6_5;
            if (!this.in.hasRemaining()) {
                this.in.rewind();
            }
            if (this.out.position() > this.in.position()) {
                this.in.limit(this.out.position());
            }
            int pos = this.in.position();
            try {
                thisTime = source.read(this.in);
                var6_5 = null;
            }
            catch (Throwable throwable) {
                var6_5 = null;
                if (this.in.position() > pos) {
                    this.lastOut = false;
                }
                throw throwable;
            }
            if (this.in.position() > pos) {
                this.lastOut = false;
            }
            this.in.limit(this.in.capacity());
            if (thisTime == 0) break;
            read += thisTime;
        }
        return read;
    }
}

