/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.util.ListCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class CoWList
implements List {
    public static final ListCreator ARRAY_LIST = new ArrayCreator();
    public static final ListCreator LINKED_LIST = new LinkedCreator();
    private volatile List l;
    private final ListCreator creator;
    private final Object lock;

    public CoWList(List l, Object lock) {
        this.l = l;
        this.creator = new ReflectiveCreator(l.getClass());
        this.lock = lock == null ? this : lock;
    }

    public CoWList(Class listType, Object lock) {
        this(new ReflectiveCreator(listType), lock);
    }

    public CoWList(ListCreator creator) {
        this(creator, null);
    }

    public CoWList(ListCreator creator, Object lock) {
        this.creator = creator;
        this.l = creator.getList();
        this.lock = lock == null ? this : lock;
    }

    private List getListCopy() {
        List ret = this.creator.getList();
        if (this.l != null) {
            ret.addAll(this.l);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int arg0, Object arg1) {
        Object object = this.lock;
        synchronized (object) {
            List newList = this.getListCopy();
            newList.add(arg0, arg1);
            this.l = newList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object arg0) {
        Object object = this.lock;
        synchronized (object) {
            List newList = this.getListCopy();
            boolean ret = newList.add(arg0);
            this.l = newList;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection arg0) {
        Object object = this.lock;
        synchronized (object) {
            List newList = this.getListCopy();
            boolean ret = newList.addAll(arg0);
            this.l = newList;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int arg0, Collection arg1) {
        Object object = this.lock;
        synchronized (object) {
            List newList = this.getListCopy();
            boolean ret = newList.addAll(arg0, arg1);
            this.l = newList;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            List newList = this.getListCopy();
            newList.clear();
            this.l = newList;
        }
    }

    public boolean contains(Object o) {
        return this.l.contains(o);
    }

    public boolean containsAll(Collection arg0) {
        return this.l.containsAll(arg0);
    }

    public Object get(int index) {
        return this.l.get(index);
    }

    public int indexOf(Object o) {
        return this.l.indexOf(o);
    }

    public boolean isEmpty() {
        return this.l.isEmpty();
    }

    public Iterator iterator() {
        return this.l.iterator();
    }

    public int lastIndexOf(Object o) {
        return this.l.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.l.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.l.listIterator(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int index) {
        Object object = this.lock;
        synchronized (object) {
            Object ret = null;
            List newList = this.getListCopy();
            ret = newList.remove(index);
            this.l = newList;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        Object object = this.lock;
        synchronized (object) {
            List newList = this.getListCopy();
            boolean ret = newList.remove(o);
            this.l = newList;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection arg0) {
        Object object = this.lock;
        synchronized (object) {
            List newList = this.getListCopy();
            boolean ret = newList.removeAll(arg0);
            this.l = newList;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection arg0) {
        Object object = this.lock;
        synchronized (object) {
            List newList = this.getListCopy();
            boolean ret = newList.retainAll(arg0);
            this.l = newList;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int arg0, Object arg1) {
        Object object = this.lock;
        synchronized (object) {
            List newList = this.getListCopy();
            Object ret = newList.set(arg0, arg1);
            this.l = newList;
            return ret;
        }
    }

    public int size() {
        return this.l.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.l.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.l.toArray();
    }

    public Object[] toArray(Object[] arg0) {
        return this.l.toArray(arg0);
    }

    public String toString() {
        return this.l.toString();
    }

    private static class LinkedCreator
    implements ListCreator {
        private LinkedCreator() {
        }

        public List getList() {
            return new LinkedList();
        }
    }

    private static class ArrayCreator
    implements ListCreator {
        private ArrayCreator() {
        }

        public List getList() {
            return new ArrayList();
        }
    }

    private static class ReflectiveCreator
    implements ListCreator {
        private final Class listType;

        public ReflectiveCreator(Class c) {
            this.listType = c;
        }

        public List getList() {
            List ret = null;
            try {
                ret = (List)this.listType.newInstance();
            }
            catch (IllegalAccessException bad) {
                ErrorService.error(bad);
            }
            catch (InstantiationException bad) {
                ErrorService.error(bad);
            }
            return ret;
        }
    }
}

