/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.ThreadPool;
import java.util.LinkedList;
import java.util.List;

public class DefaultThreadPool
implements ThreadPool {
    private final List QUEUE = new LinkedList();
    private final String NAME;
    private final boolean MANAGED;
    private final int MAX_THREADS;
    private int _activeRunners;

    public DefaultThreadPool(String name) {
        this(name, true);
    }

    public DefaultThreadPool(String name, int maxThreads) {
        this(name, true, maxThreads);
    }

    public DefaultThreadPool(String name, boolean managed) {
        this(name, managed, Integer.MAX_VALUE);
    }

    public DefaultThreadPool(String name, boolean managed, int maxThreads) {
        this.NAME = name;
        this.MANAGED = managed;
        this.MAX_THREADS = maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable r) {
        DefaultThreadPool defaultThreadPool = this;
        synchronized (defaultThreadPool) {
            this.QUEUE.add(r);
            this.notifyAll();
        }
        Thread.yield();
        defaultThreadPool = this;
        synchronized (defaultThreadPool) {
            this.startRunnerIfPossibleAndNecessary();
        }
    }

    private synchronized void startRunnerIfPossibleAndNecessary() {
        if (!this.QUEUE.isEmpty() && this._activeRunners < this.MAX_THREADS) {
            Thread runner = this.MANAGED ? new ManagedThread(new Processor(), this.NAME) : new Thread((Runnable)new Processor(), this.NAME);
            runner.setDaemon(true);
            ++this._activeRunners;
            runner.start();
        }
    }

    private synchronized Runnable next() {
        if (!this.QUEUE.isEmpty()) {
            return (Runnable)this.QUEUE.remove(0);
        }
        return null;
    }

    private class Processor
    implements Runnable {
        private Processor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            DefaultThreadPool defaultThreadPool;
            try {
                Runnable next = DefaultThreadPool.this.next();
                while (true) {
                    if (next != null) {
                        next.run();
                    }
                    DefaultThreadPool defaultThreadPool2 = DefaultThreadPool.this;
                    synchronized (defaultThreadPool2) {
                        next = DefaultThreadPool.this.next();
                        if (next != null) {
                            continue;
                        }
                        try {
                            DefaultThreadPool.this.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        next = DefaultThreadPool.this.next();
                        if (next == null) break;
                    }
                }
                {
                }
                Object var6_4 = null;
                defaultThreadPool = DefaultThreadPool.this;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                DefaultThreadPool defaultThreadPool3 = DefaultThreadPool.this;
                synchronized (defaultThreadPool3) {
                    DefaultThreadPool.this._activeRunners--;
                    DefaultThreadPool.this.startRunnerIfPossibleAndNecessary();
                    throw throwable;
                }
            }
            synchronized (defaultThreadPool) {
                DefaultThreadPool.this._activeRunners--;
                DefaultThreadPool.this.startRunnerIfPossibleAndNecessary();
                return;
            }
        }
    }
}

