/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.NoMoreStorageException;
import java.util.HashMap;
import java.util.Map;

public class FixedsizeHashMap {
    private final Map hashMap;
    private final int maxSize;

    public FixedsizeHashMap(int size) {
        this.hashMap = new HashMap(size * 4 / 3);
        this.maxSize = size;
    }

    public synchronized Object put(Object key, Object value) throws NoMoreStorageException {
        Object retValue = null;
        if (this.hashMap.size() < this.maxSize) {
            retValue = this.hashMap.put(key, value);
        } else {
            retValue = this.hashMap.get(key);
            if (retValue != null) {
                retValue = this.hashMap.put(key, value);
            } else {
                throw new NoMoreStorageException();
            }
        }
        return retValue;
    }

    public synchronized Object get(Object key) {
        return this.hashMap.get(key);
    }

    public synchronized void clear() {
        this.hashMap.clear();
    }

    public synchronized String toString() {
        return this.hashMap.toString();
    }
}

