/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.Hasher;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class HasherSet
extends HashSet {
    private static final Hasher DEFAULT = new DefaultHasher();
    private Hasher _hasher;

    public HasherSet(Hasher h) {
        this._hasher = h;
    }

    public HasherSet() {
        this._hasher = DEFAULT;
    }

    public HasherSet(Hasher h, Collection c) {
        this._hasher = h;
        this.addAll(c);
    }

    public HasherSet(Collection c) {
        this(DEFAULT, c);
    }

    public boolean add(Object arg0) {
        return super.add(this.wrap(arg0));
    }

    public boolean addAll(Collection arg0) {
        return super.addAll(this.wrap(arg0));
    }

    public boolean contains(Object o) {
        return super.contains(this.wrap(o));
    }

    public boolean containsAll(Collection arg0) {
        return super.containsAll(this.wrap(arg0));
    }

    public Iterator iterator() {
        return new UnwrapIterator();
    }

    public boolean remove(Object o) {
        return super.remove(this.wrap(o));
    }

    public boolean retainAll(Collection arg0) {
        return super.retainAll(this.wrap(arg0));
    }

    private Collection wrap(Collection c) {
        if (c instanceof HasherSet) {
            return c;
        }
        HashSet<Wrapper> tmp = new HashSet<Wrapper>();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object next = i.next();
            tmp.add(this.wrap(next));
        }
        return tmp;
    }

    private Wrapper wrap(Object o) {
        if (o instanceof Wrapper) {
            return (Wrapper)o;
        }
        return new Wrapper(o);
    }

    private static final class DefaultHasher
    implements Hasher {
        private DefaultHasher() {
        }

        public int hash(Object o) {
            return o.hashCode();
        }

        public boolean areEqual(Object a, Object b) {
            return a.equals(b);
        }
    }

    private final class UnwrapIterator
    implements Iterator {
        private final Iterator _iter;

        public UnwrapIterator() {
            this._iter = HasherSet.super.iterator();
        }

        public boolean hasNext() {
            return this._iter.hasNext();
        }

        public Object next() {
            Wrapper wr = (Wrapper)this._iter.next();
            return wr.getObj();
        }

        public void remove() {
            this._iter.remove();
        }
    }

    private final class Wrapper {
        private final Object _obj;

        public Wrapper(Object o) {
            this._obj = o;
        }

        public int hashCode() {
            return HasherSet.this._hasher.hash(this._obj);
        }

        public boolean equals(Object other) {
            if (other instanceof Wrapper) {
                return HasherSet.this._hasher.areEqual(this._obj, ((Wrapper)other).getObj());
            }
            return false;
        }

        public Object getObj() {
            return this._obj;
        }
    }
}

