/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.io.NBSocket;
import com.limegroup.gnutella.io.Shutdownable;
import com.limegroup.gnutella.io.SocketFactory;
import com.limegroup.gnutella.util.ProxyUtils;
import com.limegroup.gnutella.util.SimpleSocketController;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class LimitedSocketController
extends SimpleSocketController {
    private final int MAX_CONNECTING_SOCKETS;
    private int _socketsConnecting = 0;
    private final List WAITING_REQUESTS = new LinkedList();

    LimitedSocketController(int max) {
        this.MAX_CONNECTING_SOCKETS = max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Socket connectPlain(InetSocketAddress addr, int timeout, ConnectObserver observer) throws IOException {
        NBSocket socket = SocketFactory.newSocket();
        if (observer == null) {
            this.waitForSocket();
            try {
                socket.connect(addr, timeout);
            }
            finally {
                this.releaseSocket();
            }
        } else if (this.addWaitingSocket(socket, addr, timeout, observer)) {
            socket.connect(addr, timeout, new DelegateConnector(observer));
        }
        return socket;
    }

    public synchronized boolean removeConnectObserver(ConnectObserver observer) {
        Iterator i = this.WAITING_REQUESTS.iterator();
        while (i.hasNext()) {
            Requestor next = (Requestor)i.next();
            if (next.observer == observer) {
                i.remove();
                return true;
            }
            if (!(next.observer instanceof ProxyUtils.ProxyConnector) || ((ProxyUtils.ProxyConnector)next.observer).getDelegateObserver() != observer) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public int getNumAllowedSockets() {
        return this.MAX_CONNECTING_SOCKETS;
    }

    public synchronized int getNumWaitingSockets() {
        return this.WAITING_REQUESTS.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWaitingRequests() {
        Requestor next;
        ArrayList<Requestor> toBeProcessed = new ArrayList<Requestor>(Math.min(this.WAITING_REQUESTS.size(), Math.max(0, this.MAX_CONNECTING_SOCKETS - this._socketsConnecting)));
        LimitedSocketController limitedSocketController = this;
        synchronized (limitedSocketController) {
            while (this._socketsConnecting < this.MAX_CONNECTING_SOCKETS && !this.WAITING_REQUESTS.isEmpty()) {
                next = (Requestor)this.WAITING_REQUESTS.remove(0);
                if (next.socket.isClosed()) continue;
                toBeProcessed.add(next);
                ++this._socketsConnecting;
            }
        }
        for (int i = 0; i < toBeProcessed.size(); ++i) {
            next = (Requestor)toBeProcessed.get(i);
            next.socket.setShutdownObserver(null);
            next.socket.connect(next.addr, next.timeout, new DelegateConnector(next.observer));
        }
    }

    private synchronized boolean addWaitingSocket(NBSocket socket, InetSocketAddress addr, int timeout, ConnectObserver observer) {
        if (this._socketsConnecting >= this.MAX_CONNECTING_SOCKETS) {
            this.WAITING_REQUESTS.add(new Requestor(socket, addr, timeout, observer));
            socket.setShutdownObserver(new RemovalObserver(observer));
            return false;
        }
        ++this._socketsConnecting;
        return true;
    }

    private synchronized void waitForSocket() throws IOException {
        while (this._socketsConnecting >= this.MAX_CONNECTING_SOCKETS) {
            try {
                this.wait();
            }
            catch (InterruptedException ix) {
                throw new IOException(ix.getMessage());
            }
        }
        ++this._socketsConnecting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSocket() {
        LimitedSocketController limitedSocketController = this;
        synchronized (limitedSocketController) {
            --this._socketsConnecting;
        }
        this.runWaitingRequests();
        limitedSocketController = this;
        synchronized (limitedSocketController) {
            if (this._socketsConnecting < this.MAX_CONNECTING_SOCKETS) {
                this.notifyAll();
            }
        }
    }

    private static class Requestor {
        private final InetSocketAddress addr;
        private final int timeout;
        private final NBSocket socket;
        private final ConnectObserver observer;

        Requestor(NBSocket socket, InetSocketAddress addr, int timeout, ConnectObserver observer) {
            this.socket = socket;
            this.addr = addr;
            this.timeout = timeout;
            this.observer = observer;
        }
    }

    private class DelegateConnector
    implements ConnectObserver {
        private final ConnectObserver delegate;

        DelegateConnector(ConnectObserver observer) {
            this.delegate = observer;
        }

        public void handleConnect(Socket s) throws IOException {
            LimitedSocketController.this.releaseSocket();
            this.delegate.handleConnect(s);
        }

        public void shutdown() {
            LimitedSocketController.this.releaseSocket();
            this.delegate.shutdown();
        }

        public void handleIOException(IOException x) {
        }
    }

    private class RemovalObserver
    implements Shutdownable {
        private final ConnectObserver delegate;

        RemovalObserver(ConnectObserver observer) {
            this.delegate = observer;
        }

        public void shutdown() {
            if (LimitedSocketController.this.removeConnectObserver(this.delegate)) {
                this.delegate.shutdown();
            }
        }
    }
}

