/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.IPPortCombo;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortForSelf;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class NetworkUtils {
    private static final byte[] INVALID_ADDRESSES_BYTE = new byte[]{0, -1};
    private static final int[][] PRIVATE_ADDRESSES_BYTE = new int[][]{{-16777216, 0}, {-16777216, 0x7F000000}, {-16777216, -16777216}, {-16777216, 0xA000000}, {-1048576, -1408237568}, {-65536, -1442971648}, {-65536, -1062731776}};
    private static final byte LOCAL_ADDRESS_BYTE = 127;

    private NetworkUtils() {
    }

    public static boolean isValidAddressAndPort(byte[] addr, int port) {
        return NetworkUtils.isValidAddress(addr) && NetworkUtils.isValidPort(port);
    }

    public static boolean isValidAddressAndPort(String addr, int port) {
        return NetworkUtils.isValidAddress(addr) && NetworkUtils.isValidPort(port);
    }

    public static boolean isValidPort(int port) {
        if ((port & 0xFFFF0000) != 0) {
            return false;
        }
        return port != 0;
    }

    public static boolean isValidAddress(byte[] addr) {
        return addr[0] != INVALID_ADDRESSES_BYTE[0] && addr[0] != INVALID_ADDRESSES_BYTE[1];
    }

    public static boolean isValidAddress(InetAddress addr) {
        return NetworkUtils.isValidAddress(addr.getAddress());
    }

    public static boolean isValidAddress(String host) {
        try {
            return NetworkUtils.isValidAddress(InetAddress.getByName(host));
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }

    public static boolean isLocalAddress(InetAddress addr) {
        try {
            if (addr.getAddress()[0] == 127) {
                return true;
            }
            InetAddress address = InetAddress.getLocalHost();
            return Arrays.equals(address.getAddress(), addr.getAddress());
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static boolean isCloseIP(byte[] addr0, byte[] addr1) {
        return addr0[0] == addr1[0];
    }

    public static boolean isVeryCloseIP(byte[] addr0, byte[] addr1) {
        if (NetworkUtils.isPrivateAddress(addr0)) {
            return false;
        }
        return addr0[0] == addr1[0] && addr0[1] == addr1[1];
    }

    public static boolean isVeryCloseIP(byte[] addr) {
        return NetworkUtils.isVeryCloseIP(RouterService.getAddress(), addr);
    }

    public static boolean isPrivate() {
        return NetworkUtils.isPrivateAddress(RouterService.getAddress());
    }

    public static boolean isPrivateAddress(byte[] address) {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return false;
        }
        int addr = (address[0] & 0xFF) << 24 | (address[1] & 0xFF) << 16;
        for (int i = 0; i < 7; ++i) {
            if ((addr & PRIVATE_ADDRESSES_BYTE[i][0]) != PRIVATE_ADDRESSES_BYTE[i][1]) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrivateAddress(InetAddress address) {
        return NetworkUtils.isPrivateAddress(address.getAddress());
    }

    public static boolean isPrivateAddress(String address) {
        try {
            return NetworkUtils.isPrivateAddress(InetAddress.getByName(address));
        }
        catch (UnknownHostException uhe) {
            return true;
        }
    }

    public static final String ip2string(byte[] ip) {
        return NetworkUtils.ip2string(ip, 0);
    }

    public static final String ip2string(byte[] ip, int offset) {
        StringBuffer sbuf = new StringBuffer(16);
        sbuf.append(ByteOrder.ubyte2int(ip[offset]));
        sbuf.append('.');
        sbuf.append(ByteOrder.ubyte2int(ip[offset + 1]));
        sbuf.append('.');
        sbuf.append(ByteOrder.ubyte2int(ip[offset + 2]));
        sbuf.append('.');
        sbuf.append(ByteOrder.ubyte2int(ip[offset + 3]));
        return sbuf.toString();
    }

    public static boolean isMe(String host, int port) {
        byte[] cIP;
        try {
            cIP = InetAddress.getByName(host).getAddress();
        }
        catch (IOException e) {
            return false;
        }
        return NetworkUtils.isMe(cIP, port);
    }

    public static boolean isMe(byte[] cIP, int port) {
        if (cIP[0] == 127) {
            return port == RouterService.getPort();
        }
        byte[] managerIP = RouterService.getAddress();
        return port == RouterService.getPort() && Arrays.equals(cIP, managerIP);
    }

    public static boolean isMe(IpPort me) {
        if (me == IpPortForSelf.instance()) {
            return true;
        }
        return NetworkUtils.isMe(me.getInetAddress().getAddress(), me.getPort());
    }

    public static boolean isLocalHost(Socket s) {
        String hostAddress = s.getInetAddress().getHostAddress();
        return "127.0.0.1".equals(hostAddress);
    }

    public static byte[] packIpPorts(Collection ipPorts) {
        byte[] data = new byte[ipPorts.size() * 6];
        int offset = 0;
        Iterator i = ipPorts.iterator();
        while (i.hasNext()) {
            IpPort next = (IpPort)i.next();
            byte[] addr = next.getInetAddress().getAddress();
            int port = next.getPort();
            System.arraycopy(addr, 0, data, offset, 4);
            ByteOrder.short2leb((short)port, data, offset += 4);
            offset += 2;
        }
        return data;
    }

    public static List unpackIps(byte[] data) throws BadPacketException {
        if (data.length % 6 != 0) {
            throw new BadPacketException("invalid size");
        }
        int size = data.length / 6;
        ArrayList<IPPortCombo> ret = new ArrayList<IPPortCombo>(size);
        byte[] current = new byte[6];
        for (int i = 0; i < size; ++i) {
            System.arraycopy(data, i * 6, current, 0, 6);
            ret.add(IPPortCombo.getCombo(current));
        }
        return Collections.unmodifiableList(ret);
    }

    public static List unpackPushEPs(InputStream is) throws BadPacketException, IOException {
        LinkedList<PushEndpoint> ret = new LinkedList<PushEndpoint>();
        DataInputStream dais = new DataInputStream(is);
        while (dais.available() > 0) {
            ret.add(PushEndpoint.fromBytes(dais));
        }
        return Collections.unmodifiableList(ret);
    }

    public static InetAddress getByAddress(byte[] addr) throws UnknownHostException {
        return InetAddress.getByAddress(addr);
    }

    public static boolean isValidExternalIpPort(IpPort addr) {
        if (addr == null) {
            return false;
        }
        byte[] b = addr.getInetAddress().getAddress();
        return NetworkUtils.isValidAddress(b) && !NetworkUtils.isPrivateAddress(b) && NetworkUtils.isValidPort(addr.getPort());
    }

    public static InetAddress getLocalAddress() throws UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        if (addr instanceof Inet4Address && !addr.isLoopbackAddress()) {
            return addr;
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    Enumeration<InetAddress> addresses = interfaces.nextElement().getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        addr = addresses.nextElement();
                        if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                        return addr;
                    }
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        throw new UnknownHostException("localhost has no interface with a non-loopback IPv4 address");
    }
}

