/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ErrorService;
import java.util.Timer;
import java.util.TimerTask;

public class SimpleTimer {
    private final Timer TIMER;
    private volatile boolean cancelled = false;

    public SimpleTimer(boolean isDaemon) {
        this.TIMER = new Timer(isDaemon);
    }

    public void schedule(final Runnable task, long delay, long period) throws IllegalStateException {
        block6: {
            if (delay < 0L) {
                throw new IllegalArgumentException("Negative delay: " + delay);
            }
            if (period < 0L) {
                throw new IllegalArgumentException("Negative period: " + period);
            }
            TimerTask tt = new TimerTask(){

                public void run() {
                    try {
                        task.run();
                    }
                    catch (Throwable t) {
                        ErrorService.error(t);
                    }
                }
            };
            try {
                if (period == 0L) {
                    this.TIMER.schedule(tt, delay);
                } else {
                    this.TIMER.schedule(tt, delay, period);
                }
            }
            catch (IllegalStateException ise) {
                if (!this.cancelled) break block6;
                throw ise;
            }
        }
    }

    public void cancel() {
        this.cancelled = true;
        this.TIMER.cancel();
    }
}

