/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.LimitedSocketController;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.SimpleSocketController;
import com.limegroup.gnutella.util.SocketController;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class Sockets {
    private static final SocketController CONTROLLER = CommonUtils.isWindowsXP() ? new LimitedSocketController(4) : new SimpleSocketController();

    private Sockets() {
    }

    public static Socket connect(String host, int port, int timeout) throws IOException {
        return Sockets.connect(host, port, timeout, null);
    }

    public static Socket connect(String host, int port, int timeout, ConnectObserver observer) throws IOException {
        InetAddress address = InetAddress.getByName(host);
        InetSocketAddress addr = new InetSocketAddress(address, port);
        return Sockets.connect(addr, timeout, observer);
    }

    public static Socket connect(IpPort ipport, int timeout, ConnectObserver observer) throws IOException {
        InetSocketAddress addr = new InetSocketAddress(ipport.getInetAddress(), ipport.getPort());
        return Sockets.connect(addr, timeout, observer);
    }

    public static Socket connect(InetSocketAddress addr, int timeout, ConnectObserver observer) throws IOException {
        if (!NetworkUtils.isValidPort(addr.getPort())) {
            throw new IllegalArgumentException("port out of range: " + addr.getPort());
        }
        return CONTROLLER.connect(addr, timeout, observer);
    }

    public static boolean removeConnectObserver(ConnectObserver observer) {
        return CONTROLLER.removeConnectObserver(observer);
    }

    public static int getNumAllowedSockets() {
        return CONTROLLER.getNumAllowedSockets();
    }

    public static int getNumWaitingSockets() {
        return CONTROLLER.getNumWaitingSockets();
    }
}

