/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.util.I18NConvert;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    private static final List TRIVIAL_WORDS = new ArrayList(3);
    private static final Collator COLLATOR;

    public static final boolean contains(String input, String pattern) {
        return StringUtils.contains(input, pattern, false);
    }

    public static final boolean contains(String input, String pattern, boolean ignoreCase) {
        int n = pattern.length();
        int last = 0;
        int i = 0;
        while (i < n) {
            int k;
            int j;
            int c = 32;
            for (j = i; j < n; ++j) {
                char c2 = pattern.charAt(j);
                if (c2 != ' ' && c2 != '+' && c2 != '*') continue;
                c = c2;
                break;
            }
            if ((k = StringUtils.subset(pattern, i, j, input, last, ignoreCase)) < 0) {
                return false;
            }
            if (c == 32 || c == 43) {
                last = 0;
            } else if (c == 42) {
                last = k + j - i;
            }
            i = j + 1;
        }
        return true;
    }

    public static boolean containsCharacters(String input, char[] chars) {
        char[] inputChars = input.toCharArray();
        Arrays.sort(inputChars);
        for (int i = 0; i < chars.length; ++i) {
            if (Arrays.binarySearch(inputChars, chars[i]) < 0) continue;
            return true;
        }
        return false;
    }

    private static final int subset(String little, int littleStart, int littleStop, String big, int bigStart, boolean ignoreCase) {
        if (ignoreCase) {
            int n = big.length() - (littleStop - littleStart) + 1;
            block0: for (int i = bigStart; i < n; ++i) {
                int n2 = littleStop - littleStart;
                for (int j = 0; j < n2; ++j) {
                    char c2;
                    char c1 = big.charAt(i + j);
                    if (c1 != (c2 = little.charAt(littleStart + j)) && c1 != StringUtils.toOtherCase(c2)) continue block0;
                }
                return i;
            }
            return -1;
        }
        int n = big.length() - (littleStop - littleStart) + 1;
        block2: for (int i = bigStart; i < n; ++i) {
            int n2 = littleStop - littleStart;
            for (int j = 0; j < n2; ++j) {
                char c2;
                char c1 = big.charAt(i + j);
                if (c1 != (c2 = little.charAt(littleStart + j))) continue block2;
            }
            return i;
        }
        return -1;
    }

    public static final char toOtherCase(char c) {
        char i = c;
        int A = 65;
        int Z = 90;
        int a = 97;
        int z = 122;
        int SHIFT = 32;
        if (i < 'A') {
            return c;
        }
        if (i <= 'Z') {
            return (char)(i + 32);
        }
        if (i < 'a') {
            return c;
        }
        if (i <= 'z') {
            return (char)(i - 32);
        }
        return c;
    }

    public static String[] split(String s, char delimiter) {
        return StringUtils.split(s, delimiter + "");
    }

    public static String[] split(String s, String delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters);
        Vector<String> buf = new Vector<String>();
        while (tokenizer.hasMoreTokens()) {
            buf.add(tokenizer.nextToken());
        }
        String[] ret = new String[buf.size()];
        for (int i = 0; i < buf.size(); ++i) {
            ret[i] = (String)buf.get(i);
        }
        return ret;
    }

    public static String[] splitNoCoalesce(String s, char delimiter) {
        return StringUtils.splitNoCoalesce(s, delimiter + "");
    }

    public static String[] splitNoCoalesce(String s, String delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters, true);
        Vector<String> buf = new Vector<String>();
        boolean gotDelimiter = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 1 && delimiters.indexOf(token) >= 0) {
                if (gotDelimiter) {
                    buf.add("");
                }
                gotDelimiter = true;
                continue;
            }
            buf.add(token);
            gotDelimiter = false;
        }
        if (gotDelimiter && !buf.isEmpty()) {
            buf.add("");
        }
        String[] ret = new String[buf.size()];
        for (int i = 0; i < buf.size(); ++i) {
            ret[i] = (String)buf.get(i);
        }
        return ret;
    }

    public static int compareIgnoreCase(String s1, String s2) {
        int n1 = s1.length();
        int n2 = s2.length();
        int lim = Math.min(n1, n2);
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1 = s1.charAt(k);
            if (c1 == (c2 = s2.charAt(k)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
            return c1 - c2;
        }
        return n1 - n2;
    }

    public static int compareFullPrimary(String s1, String s2) {
        return COLLATOR.compare(s1, s2);
    }

    public static boolean startsWithIgnoreCase(String s, String prefix) {
        int pl = prefix.length();
        if (s.length() < pl) {
            return false;
        }
        for (int i = 0; i < pl; ++i) {
            char pc;
            char sc = s.charAt(i);
            if (sc == (pc = prefix.charAt(i)) || (sc = Character.toUpperCase(sc)) == (pc = Character.toUpperCase(pc)) || (sc = Character.toLowerCase(sc)) == (pc = Character.toLowerCase(pc))) continue;
            return false;
        }
        return true;
    }

    public static String getEntriesAsString(Collection collection) {
        StringBuffer buffer = new StringBuffer();
        boolean isFirstEntry = true;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object entry = iter.next();
            if (!isFirstEntry) {
                buffer.append(",");
            } else {
                isFirstEntry = false;
            }
            buffer.append(entry.toString());
        }
        return buffer.toString();
    }

    public static Set getSetofValues(String values) {
        HashSet<String> valueSet = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(values, ",");
        while (st.hasMoreTokens()) {
            valueSet.add(st.nextToken());
        }
        return valueSet;
    }

    public static String replace(String str, String old_str, String new_str) {
        int o = 0;
        StringBuffer buf = new StringBuffer();
        int i = str.indexOf(old_str);
        while (i > -1) {
            if (i > o) {
                buf.append(str.substring(o, i));
            }
            buf.append(new_str);
            o = i + old_str.length();
            i = str.indexOf(old_str, i + 1);
        }
        buf.append(str.substring(o, str.length()));
        return buf.toString();
    }

    public static String truncate(String string, int maxLen) {
        if (string.length() <= maxLen) {
            return string;
        }
        return string.substring(0, maxLen);
    }

    public static int indexOfIgnoreCase(String str, String substring) {
        return str.toLowerCase().indexOf(substring.toLowerCase());
    }

    public static String createQueryString(String name) {
        return StringUtils.createQueryString(name, false);
    }

    public static String createQueryString(String name, boolean allowNumbers) {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        String retString = null;
        name = I18NConvert.instance().getNorm(name);
        int MAX_LEN = SearchSettings.MAX_QUERY_LENGTH.getValue();
        Set intersection = StringUtils.keywords(name, allowNumbers);
        if (intersection.size() < 1) {
            retString = StringUtils.removeIllegalChars(name);
            retString = StringUtils.truncate(retString, MAX_LEN);
        } else {
            StringBuffer sb = new StringBuffer();
            int numWritten = 0;
            Iterator keys = intersection.iterator();
            while (keys.hasNext() && numWritten < MAX_LEN) {
                String currKey = (String)keys.next();
                if (numWritten + currKey.length() >= MAX_LEN) continue;
                if (numWritten > 0) {
                    sb.append(" ");
                    ++numWritten;
                }
                sb.append(currKey);
                numWritten += currKey.length();
            }
            retString = sb.toString();
            if (retString.equals("")) {
                retString = StringUtils.truncate(name, MAX_LEN);
            }
        }
        Assert.that(retString.length() <= MAX_LEN, "Original filename: " + name + ", converted: " + retString);
        if (!intersection.isEmpty()) {
            Assert.that(!retString.equals(""), "Original filename: " + name);
        }
        Assert.that(retString != null, "Original filename: " + name);
        return retString;
    }

    public static final String removeIllegalChars(String name) {
        String ret = "";
        String delim = " -._+/*()\\,";
        char[] illegal = SearchSettings.ILLEGAL_CHARS.getValue();
        StringBuffer sb = new StringBuffer(delim.length() + illegal.length);
        sb.append(illegal).append(" -._+/*()\\,");
        StringTokenizer st = new StringTokenizer(name, sb.toString());
        while (st.hasMoreTokens()) {
            ret = ret + st.nextToken().trim() + " ";
        }
        return ret.trim();
    }

    public static final Set keywords(String fileName) {
        return StringUtils.keywords(fileName, false);
    }

    public static final Set keywords(String fileName, boolean allowNumbers) {
        fileName = StringUtils.ripExtension(fileName);
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        String delim = " -._+/*()\\,";
        char[] illegal = SearchSettings.ILLEGAL_CHARS.getValue();
        StringBuffer sb = new StringBuffer(delim.length() + illegal.length);
        sb.append(illegal).append(" -._+/*()\\,");
        StringTokenizer st = new StringTokenizer(fileName, sb.toString());
        while (st.hasMoreTokens()) {
            String currToken = st.nextToken().toLowerCase();
            try {
                Double.valueOf(currToken);
                if (!allowNumbers) {
                    continue;
                }
            }
            catch (NumberFormatException normalWord) {
                // empty catch block
            }
            if (TRIVIAL_WORDS.contains(currToken)) continue;
            ret.add(currToken);
        }
        return ret;
    }

    public static String ripExtension(String fileName) {
        String retString = null;
        int extStart = fileName.lastIndexOf(46);
        retString = extStart == -1 ? fileName : fileName.substring(0, extStart);
        return retString;
    }

    static {
        TRIVIAL_WORDS.add("the");
        TRIVIAL_WORDS.add("an");
        TRIVIAL_WORDS.add("a");
        TRIVIAL_WORDS.add("and");
        COLLATOR = Collator.getInstance(new Locale(ApplicationSettings.LANGUAGE.getValue(), ApplicationSettings.COUNTRY.getValue(), ApplicationSettings.LOCALE_VARIANT.getValue()));
        COLLATOR.setDecomposition(2);
        COLLATOR.setStrength(0);
    }
}

