/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.version;

import com.limegroup.gnutella.util.CommonUtils;
import java.util.StringTokenizer;

class OS {
    private final String os;
    private final boolean acceptable;

    OS(String s) {
        this.os = s;
        this.acceptable = this.accept(s.toLowerCase());
    }

    public String toString() {
        return this.os;
    }

    public boolean isAcceptable() {
        return this.acceptable;
    }

    static OS[] createFromList(String oses) {
        StringTokenizer st = new StringTokenizer(oses, ",");
        OS[] all = new OS[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            all[i] = new OS(st.nextToken().trim());
            ++i;
        }
        return all;
    }

    static boolean hasAcceptableOS(OS[] oses) {
        for (int i = 0; i < oses.length; ++i) {
            if (!oses[i].isAcceptable()) continue;
            return true;
        }
        return false;
    }

    static String toString(OS[] oses) {
        if (oses == null) {
            return "";
        }
        String s = "";
        for (int i = 0; i < oses.length; ++i) {
            s = s + oses[i].toString();
            if (i >= oses.length - 2) continue;
            s = s + ", ";
        }
        return s;
    }

    private boolean accept(String s) {
        String os = CommonUtils.getOS().toLowerCase();
        if (s.equals(os)) {
            return true;
        }
        if ("windows".equals(s)) {
            return CommonUtils.isWindows();
        }
        if ("mac".equals(s)) {
            return CommonUtils.isAnyMac();
        }
        if ("linux".equals(s)) {
            return CommonUtils.isLinux();
        }
        if ("unix".equals(s)) {
            return CommonUtils.isUnix() && !CommonUtils.isLinux();
        }
        if ("other".equals(s)) {
            return !CommonUtils.isWindows() && !CommonUtils.isAnyMac() && !CommonUtils.isUnix() && !CommonUtils.isLinux();
        }
        return "*".equals(s);
    }
}

