/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.version;

import com.limegroup.gnutella.version.VersionFormatException;

public class Version
implements Comparable {
    private final String v;
    private final int major;
    private final int minor;
    private final int service;
    private final int revision;

    public Version(String s) throws VersionFormatException {
        this.v = s;
        int[] nums = this.parse(s);
        this.major = nums[0];
        this.minor = nums[1];
        this.service = nums[2];
        this.revision = nums[3];
    }

    public String getVersion() {
        return this.v;
    }

    public String toString() {
        return this.getVersion();
    }

    public int compareTo(Object o) {
        Version other = (Version)o;
        int retVal = this.major == other.major ? (this.minor == other.minor ? (this.service == other.service ? this.revision - other.revision : this.service - other.service) : this.minor - other.minor) : this.major - other.major;
        return retVal;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    private int[] parse(String vers) throws VersionFormatException {
        int service;
        int q;
        int minor;
        int major;
        int dot1 = vers.indexOf(".");
        if (dot1 == -1) {
            throw new VersionFormatException(vers);
        }
        int dot2 = vers.indexOf(".", dot1 + 1);
        if (dot2 == -1) {
            throw new VersionFormatException(vers);
        }
        try {
            major = Integer.parseInt(vers.substring(0, dot1));
        }
        catch (NumberFormatException nfe) {
            throw new VersionFormatException(vers);
        }
        try {
            minor = Integer.parseInt(vers.substring(dot1 + 1, dot2));
        }
        catch (NumberFormatException nfe) {
            throw new VersionFormatException(vers);
        }
        try {
            for (q = dot2 + 1; q < vers.length() && Character.isDigit(vers.charAt(q)); ++q) {
            }
            int lastNum = q;
            service = Integer.parseInt(vers.substring(dot2 + 1, q));
        }
        catch (NumberFormatException nfe) {
            throw new VersionFormatException(vers);
        }
        int revision = 0;
        try {
            for (q = lastNum + 1; q < vers.length() && !Character.isDigit(vers.charAt(q)); ++q) {
            }
            if (q < vers.length()) {
                revision = Integer.parseInt(vers.substring(q));
            }
        }
        catch (NumberFormatException okay) {
            // empty catch block
        }
        return new int[]{major, minor, service, revision};
    }
}

