/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class ByteBuilder {
    public static final byte NONE = -1;
    public static final byte ISO = 0;
    public static final byte UNICODE = 1;
    protected ByteArrayOutputStream arr;
    protected byte encoding;

    public ByteBuilder(byte encoding) {
        this.arr = new ByteArrayOutputStream();
        this.encoding = encoding;
        this.checkEncoding();
    }

    public ByteBuilder(byte encoding, int size) {
        this.arr = new ByteArrayOutputStream(size);
        this.encoding = encoding;
        this.checkEncoding();
    }

    public void put(byte put) {
        this.arr.write(put);
    }

    public void put(byte[] put) {
        this.arr.write(put, 0, put.length);
    }

    public void put(String put) {
        byte[] encoded = null;
        switch (this.encoding) {
            case -1: 
            case 0: {
                try {
                    encoded = put.getBytes("ISO8859_1");
                }
                catch (UnsupportedEncodingException e) {}
                break;
            }
            case 1: {
                try {
                    encoded = put.getBytes("Unicode");
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
        }
        try {
            this.arr.write(encoded);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte[] getBytes() {
        return this.arr.toByteArray();
    }

    protected void checkEncoding() {
        if (this.encoding == 0) {
            this.arr.write(0);
        } else if (this.encoding == 1) {
            this.arr.write(1);
        }
    }
}

