/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapHeaderConstructor;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapResponse;
import de.kapsi.net.daap.Song;
import java.io.FileInputStream;
import java.io.IOException;

public abstract class DaapAudioResponse
implements DaapResponse {
    protected final DaapRequest request;
    protected final Song song;
    protected final FileInputStream in;
    protected final long end;
    protected final byte[] header;
    protected long pos;

    public DaapAudioResponse(DaapRequest request, Song song, FileInputStream in, long pos, long end) throws IOException {
        this.request = request;
        this.song = song;
        this.in = in;
        this.pos = pos;
        this.end = end;
        this.header = DaapHeaderConstructor.createAudioHeader(request, pos, end, song.getSize());
    }

    public String toString() {
        return new String(this.header);
    }

    protected void close() throws IOException {
        this.pos = this.end;
        if (this.in != null) {
            this.in.close();
        }
    }
}

