/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapResponseWriter;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.DaapSession;
import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.SessionId;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DaapConnection {
    private static final Log LOG = LogFactory.getLog((Class)(class$de$kapsi$net$daap$DaapConnection == null ? (class$de$kapsi$net$daap$DaapConnection = DaapConnection.class$("de.kapsi.net.daap.DaapConnection")) : class$de$kapsi$net$daap$DaapConnection));
    public static final int TIMEOUT = 3000;
    public static final int LIBRARY_TIMEOUT = 30000;
    protected static final int UNDEF = 0;
    protected static final int DAAP = 1;
    protected static final int AUDIO = 2;
    protected final DaapResponseWriter writer;
    protected DaapServer server;
    protected DaapSession session;
    protected int type = 0;
    protected int protocolVersion = 0;
    protected String nonce;
    protected LinkedList libraryQueue;
    protected boolean locked = false;
    static /* synthetic */ Class class$de$kapsi$net$daap$DaapConnection;

    public DaapConnection(DaapServer server) {
        this.server = server;
        this.writer = new DaapResponseWriter();
        this.libraryQueue = new LinkedList();
    }

    public abstract void update() throws IOException;

    public boolean write() throws IOException {
        return !this.writer.write() || !this.isAudioStream();
    }

    public void close() {
        this.writer.clear();
        if (this.session != null) {
            this.session.invalidate();
            this.session = null;
        }
    }

    public DaapServer getServer() {
        return this.server;
    }

    protected void setConnectionType(int type) {
        this.type = type;
    }

    protected void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public boolean isAudioStream() {
        return this.type == 2;
    }

    public boolean isDaapConnection() {
        return this.type == 1;
    }

    public boolean isUndef() {
        return this.type == 0;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public DaapSession getSession(boolean create) {
        if (this.session == null && create) {
            this.session = new DaapSession(this.server.createSessionId());
        }
        return this.session;
    }

    public SessionId getSessionId(boolean create) {
        SessionId sessionId = SessionId.INVALID;
        DaapSession session = this.getSession(create);
        if (session != null) {
            sessionId = session.getSessionId();
        }
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLibraryQueue() {
        LinkedList linkedList = this.libraryQueue;
        synchronized (linkedList) {
            this.libraryQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueLibrary(Library library) {
        LinkedList linkedList = this.libraryQueue;
        synchronized (linkedList) {
            this.libraryQueue.add(library);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Library getFirstInQueue() {
        LinkedList linkedList = this.libraryQueue;
        synchronized (linkedList) {
            if (!this.libraryQueue.isEmpty()) {
                return (Library)this.libraryQueue.getFirst();
            }
            return this.server.getLibrary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Library getLastInQueue() {
        LinkedList linkedList = this.libraryQueue;
        synchronized (linkedList) {
            if (!this.libraryQueue.isEmpty()) {
                return (Library)this.libraryQueue.getLast();
            }
            return this.server.getLibrary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Library nextLibrary(DaapRequest request) {
        LinkedList linkedList = this.libraryQueue;
        synchronized (linkedList) {
            int delta = request.getDelta();
            if (delta == 0 || this.libraryQueue.isEmpty()) {
                return this.server.getLibrary();
            }
            Library first = (Library)this.libraryQueue.getFirst();
            if (first.getRevision() != request.getRevisionNumber()) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Client doesn't request the current revision: " + delta + "/" + request.getRevisionNumber() + "/" + first.getRevision()));
                }
                this.clearLibraryQueue();
                return null;
            }
            if (delta > first.getRevision()) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Client is ahead of us: " + delta + "/" + first.getRevision()));
                }
                this.clearLibraryQueue();
                return null;
            }
            if (first.getRevision() == delta) {
                this.libraryQueue.removeFirst();
                if (this.libraryQueue.isEmpty()) {
                    return this.server.getLibrary();
                }
                if (request.getRevisionNumber() != delta) {
                    return this.nextLibrary(request);
                }
                return this.nextLibrary(new DaapRequest(this, this.getSessionId(false), request.getRevisionNumber() + 1, delta));
            }
            return first;
        }
    }

    protected synchronized void lock() {
        this.locked = true;
    }

    protected synchronized void unlock() {
        this.locked = false;
    }

    protected synchronized boolean isLocked() {
        return this.locked;
    }

    synchronized String getNonce() {
        return this.nonce;
    }

    synchronized String createNonce() {
        this.nonce = DaapUtil.nonce();
        return this.nonce;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

