/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapOutputStream;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.chunks.Chunk;
import de.kapsi.net.daap.chunks.UIntChunk;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.DigestScheme;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DaapUtil {
    private static final Log LOG = LogFactory.getLog((Class)(class$de$kapsi$net$daap$DaapUtil == null ? (class$de$kapsi$net$daap$DaapUtil = DaapUtil.class$("de.kapsi.net.daap.DaapUtil")) : class$de$kapsi$net$daap$DaapUtil));
    private static final Random generator = new Random();
    public static final int NULL = 0;
    public static final boolean COMPRESS = true;
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";
    static final byte[] CRLF = new byte[]{13, 10};
    private static final SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss z", Locale.US);
    public static final int DAAP_VERSION_1 = 65536;
    public static final int DAAP_VERSION_2 = 131072;
    public static final int DAAP_VERSION_3 = 196608;
    public static final int DAAP_VERSION_302 = 12290;
    public static final int DMAP_VERSION_201 = 131073;
    public static final int DMAP_VERSION_202 = 131074;
    public static final int MUSIC_SHARING_VERSION_201 = 131073;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String DAAP_REALM = "daap";
    private static final String[] SUPPORTED_FORMATS = new String[]{".mp3", ".m4a", ".m4p", ".wav", ".aif", ".aiff", ".m1a"};
    static /* synthetic */ Class class$de$kapsi$net$daap$DaapUtil;

    private DaapUtil() {
    }

    public static boolean isSupportedProtocolVersion(int version) {
        return version >= 196608;
    }

    public static int toContentCodeNumber(String contentCode) {
        if (contentCode.length() != 4) {
            throw new IllegalArgumentException("content code must have 4 characters!");
        }
        return (contentCode.charAt(0) & 0xFF) << 24 | (contentCode.charAt(1) & 0xFF) << 16 | (contentCode.charAt(2) & 0xFF) << 8 | contentCode.charAt(3) & 0xFF;
    }

    public static String toContentCodeString(int contentCode) {
        char[] code = new char[]{(char)(contentCode >> 24 & 0xFF), (char)(contentCode >> 16 & 0xFF), (char)(contentCode >> 8 & 0xFF), (char)(contentCode & 0xFF)};
        return new String(code);
    }

    public static final String now() {
        return formatter.format(new Date());
    }

    public static final byte[] serialize(Chunk chunk, boolean compress) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(255);
        DaapOutputStream out = null;
        if (compress) {
            GZIPOutputStream gzip = new GZIPOutputStream(buffer);
            out = new DaapOutputStream(gzip);
        } else {
            out = new DaapOutputStream(buffer);
        }
        out.writeChunk(chunk);
        out.close();
        return buffer.toByteArray();
    }

    public static final Map parseQuery(String queryString) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (queryString != null && queryString.length() != 0) {
            StringTokenizer tok = new StringTokenizer(queryString, "&");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int q = token.indexOf(61);
                if (q == -1 || q == token.length()) continue;
                String key = token.substring(0, q);
                String value = token.substring(++q);
                map.put(key, value);
            }
        }
        return map;
    }

    public static final ArrayList parseMeta(String meta) {
        StringTokenizer tok = new StringTokenizer(meta, ",");
        ArrayList<String> list = new ArrayList<String>(tok.countTokens());
        boolean flag = false;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (!flag && token.equals("dmap.itemkind")) {
                list.add(0, token);
                flag = true;
                continue;
            }
            list.add(token);
        }
        return list;
    }

    public static int toVersion(int major) {
        return DaapUtil.toVersion(major, 0, 0);
    }

    public static int toVersion(int major, int minor) {
        return DaapUtil.toVersion(major, minor, 0);
    }

    public static int toVersion(int major, int minor, int micro) {
        return (major & 0xFFFF) << 16 | (minor & 0xFF) << 8 | micro & 0xFF;
    }

    public static int getProtocolVersion(DaapRequest request) {
        if (request.isUnknownRequest()) {
            return 0;
        }
        Header header = request.getHeader("Client-DAAP-Version");
        if (header == null && request.isSongRequest()) {
            header = request.getHeader("User-Agent");
        }
        if (header == null) {
            return 0;
        }
        String name = header.getName();
        String value = header.getValue();
        if (request.isSongRequest() && name.equals("User-Agent")) {
            if (value.startsWith("iTunes/5.0")) {
                return 12290;
            }
            if (value.startsWith("iTunes/4.9") || value.startsWith("iTunes/4.8") || value.startsWith("iTunes/4.7") || value.startsWith("iTunes/4.6") || value.startsWith("iTunes/4.5")) {
                return 196608;
            }
            if (value.startsWith("iTunes/4.2") || value.startsWith("iTunes/4.1")) {
                return 131072;
            }
            if (value.startsWith("iTunes/4.0")) {
                return 65536;
            }
            return 0;
        }
        StringTokenizer tokenizer = new StringTokenizer(value, ".");
        int count = tokenizer.countTokens();
        if (count >= 2 && count <= 3) {
            try {
                int major = 0;
                int minor = 0;
                int patch = 0;
                major = Integer.parseInt(tokenizer.nextToken());
                minor = Integer.parseInt(tokenizer.nextToken());
                if (count == 3) {
                    patch = Integer.parseInt(tokenizer.nextToken());
                }
                return DaapUtil.toVersion(major, minor, patch);
            }
            catch (NumberFormatException err) {
                // empty catch block
            }
        }
        return 0;
    }

    public static long parseUInt(String value) throws NumberFormatException {
        try {
            return UIntChunk.checkUIntRange(Long.parseLong(value));
        }
        catch (IllegalArgumentException err) {
            throw new NumberFormatException("For input: " + value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nextInt() {
        Random random = generator;
        synchronized (random) {
            return generator.nextInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nextInt(int max) {
        Random random = generator;
        synchronized (random) {
            return generator.nextInt(max);
        }
    }

    public static byte[] getBytes(String s, String charsetName) {
        try {
            return s.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(byte[] b, String charsetName) {
        try {
            return new String(b, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toHexString(byte[] b) {
        if (b.length % 2 != 0) {
            throw new IllegalArgumentException("Argument's length must be power of 2");
        }
        StringBuffer buffer = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            char hi = HEX[b[i] >> 4 & 0xF];
            char lo = HEX[b[i] & 0xF];
            buffer.append(hi).append(lo);
        }
        return buffer.toString();
    }

    public static byte[] parseHexString(String s) {
        if (s.length() % 2 != 0) {
            throw new IllegalArgumentException("Argument's length() must be power of 2");
        }
        byte[] buffer = new byte[s.length() / 2];
        int j = 0;
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (byte)(DaapUtil.parseHexToInt(s.charAt(j++) & 0xFF) << 4 | DaapUtil.parseHexToInt(s.charAt(j++) & 0xFF));
        }
        return buffer;
    }

    private static int parseHexToInt(int hex) {
        switch (hex) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: {
                return 10;
            }
            case 97: {
                return 10;
            }
            case 66: {
                return 11;
            }
            case 98: {
                return 11;
            }
            case 67: {
                return 12;
            }
            case 99: {
                return 12;
            }
            case 68: {
                return 13;
            }
            case 100: {
                return 13;
            }
            case 69: {
                return 14;
            }
            case 101: {
                return 14;
            }
            case 70: {
                return 15;
            }
            case 102: {
                return 15;
            }
        }
        throw new NumberFormatException("'" + Character.toString((char)hex) + "'");
    }

    public static String nonce() {
        try {
            return DigestScheme.createCnonce();
        }
        catch (AuthenticationException err) {
            throw new RuntimeException(err);
        }
    }

    public static byte[] toMD5(String s) {
        try {
            return MessageDigest.getInstance("MD5").digest(DaapUtil.getBytes(s, ISO_8859_1));
        }
        catch (NoSuchAlgorithmException err) {
            throw new RuntimeException(err);
        }
    }

    public static String calculateHA1(String username, String password) {
        return DaapUtil.calculateHA1(username, DaapUtil.getBytes(password, ISO_8859_1));
    }

    public static String calculateHA1(String username, byte[] password) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(DaapUtil.getBytes(username, ISO_8859_1));
            md.update((byte)58);
            md.update(DaapUtil.getBytes(DAAP_REALM, ISO_8859_1));
            md.update((byte)58);
            md.update(password);
            return DaapUtil.toHexString(md.digest());
        }
        catch (NoSuchAlgorithmException err) {
            throw new RuntimeException(err);
        }
    }

    public static String calculateHA2(String uri) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(DaapUtil.getBytes("GET", ISO_8859_1));
            md.update((byte)58);
            md.update(DaapUtil.getBytes(uri, ISO_8859_1));
            return DaapUtil.toHexString(md.digest());
        }
        catch (NoSuchAlgorithmException err) {
            throw new RuntimeException(err);
        }
    }

    public static String digest(String ha1, String ha2, String nonce) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(DaapUtil.getBytes(ha1, ISO_8859_1));
            md.update((byte)58);
            md.update(DaapUtil.getBytes(nonce, ISO_8859_1));
            md.update((byte)58);
            md.update(DaapUtil.getBytes(ha2, ISO_8859_1));
            return DaapUtil.toHexString(md.digest());
        }
        catch (NoSuchAlgorithmException err) {
            throw new RuntimeException(err);
        }
    }

    public static String getExtension(File file) {
        return file.isFile() ? DaapUtil.getExtension(file.getName()) : null;
    }

    public static String getExtension(String fileName) {
        int p = fileName.lastIndexOf(46);
        if (p != -1 && ++p < fileName.length()) {
            return fileName.substring(p).toLowerCase(Locale.US);
        }
        return null;
    }

    public static boolean isSupportedFormat(File file) {
        return file.isFile() && DaapUtil.isSupportedFormat(file.getName());
    }

    public static boolean isSupportedFormat(String fileName) {
        fileName = fileName.toLowerCase(Locale.US);
        for (int i = 0; i < SUPPORTED_FORMATS.length; ++i) {
            if (!fileName.endsWith(SUPPORTED_FORMATS[i])) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

