/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapUtil;
import java.util.Set;

public final class SessionId {
    public static final SessionId INVALID = new SessionId(0);
    private final int sessionId;

    private SessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    public static SessionId createSessionId(int sessionId) {
        if (sessionId <= 0) {
            return INVALID;
        }
        return new SessionId(sessionId);
    }

    public static SessionId createSessionId(Set uniqueSet) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            int id = DaapUtil.nextInt(Integer.MAX_VALUE);
            if (id == 0) continue;
            SessionId sessionId = new SessionId(id);
            if (uniqueSet != null && uniqueSet.contains(sessionId)) continue;
            return sessionId;
        }
        throw new IndexOutOfBoundsException("All 2^31-1 IDs are in use");
    }

    public static SessionId parseSessionId(String s) throws NumberFormatException {
        return SessionId.createSessionId(Integer.parseInt(s));
    }

    public int intValue() {
        return this.sessionId;
    }

    public int hashCode() {
        return this.sessionId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SessionId)) {
            return false;
        }
        return ((SessionId)o).sessionId == this.sessionId;
    }

    public String toString() {
        return Integer.toString(this.sessionId);
    }
}

