/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapException;
import de.kapsi.net.daap.Database;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.Playlist;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.Txn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Transaction {
    protected Library library;
    protected boolean open = false;
    protected HashMap txnMap = new HashMap();

    protected Transaction(Library library) {
        this.library = library;
        this.open = true;
    }

    public Library getLibrary() {
        return this.library;
    }

    public synchronized boolean isOpen() {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() {
        block9: {
            if (!this.isOpen()) {
                throw new DaapException("Transaction is not open");
            }
            try {
                if (this.txnMap.isEmpty()) break block9;
                Library library = this.library;
                synchronized (library) {
                    Iterator it = this.txnMap.keySet().iterator();
                    while (it.hasNext()) {
                        Object key = it.next();
                        Iterator txn = ((List)this.txnMap.get(key)).iterator();
                        while (txn.hasNext()) {
                            ((Txn)txn.next()).commit(this);
                        }
                    }
                    this.library.commit(this);
                }
            }
            finally {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback() {
        block9: {
            if (!this.isOpen()) {
                throw new DaapException("Transaction is not open");
            }
            try {
                if (this.txnMap.isEmpty()) break block9;
                Library library = this.library;
                synchronized (library) {
                    Iterator it = this.txnMap.keySet().iterator();
                    while (it.hasNext()) {
                        Iterator txn = ((List)it.next()).iterator();
                        while (txn.hasNext()) {
                            ((Txn)txn.next()).rollback(this);
                        }
                    }
                    this.library.rollback(this);
                }
            }
            finally {
                this.close();
            }
        }
    }

    protected synchronized void addTxn(Object obj, Txn txn) {
        ArrayList<Txn> list = (ArrayList<Txn>)this.txnMap.get(obj);
        if (list == null || list == Collections.EMPTY_LIST) {
            list = new ArrayList<Txn>();
            this.txnMap.put(obj, list);
        }
        list.add(txn);
    }

    protected synchronized void attach(Object obj) {
        if (!this.txnMap.containsKey(obj)) {
            this.txnMap.put(obj, Collections.EMPTY_LIST);
        }
    }

    protected synchronized boolean modified(Library library) {
        if (this.txnMap.containsKey(library)) {
            return true;
        }
        Iterator it = library.getDatabases().iterator();
        while (it.hasNext()) {
            if (!this.modified((Database)it.next())) continue;
            this.txnMap.put(library, Collections.EMPTY_LIST);
            return true;
        }
        return false;
    }

    protected synchronized boolean modified(Database database) {
        if (this.txnMap.containsKey(database)) {
            return true;
        }
        Iterator it = database.getPlaylists().iterator();
        while (it.hasNext()) {
            if (!this.modified((Playlist)it.next())) continue;
            this.txnMap.put(database, Collections.EMPTY_LIST);
            return true;
        }
        return false;
    }

    protected synchronized boolean modified(Playlist playlist) {
        if (this.txnMap.containsKey(playlist)) {
            return true;
        }
        Iterator it = playlist.getSongs().iterator();
        while (it.hasNext()) {
            if (!this.modified((Song)it.next())) continue;
            this.txnMap.put(playlist, Collections.EMPTY_LIST);
            return true;
        }
        return false;
    }

    protected synchronized boolean modified(Song song) {
        return this.txnMap.containsKey(song);
    }

    protected void close() {
        if (this.open) {
            this.library.close(this);
            this.open = false;
            if (this.txnMap != null) {
                this.txnMap.clear();
                this.txnMap = null;
            }
        }
    }

    public String toString() {
        return "Transaction: " + this.library;
    }
}

