/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.chunks;

import de.kapsi.net.daap.chunks.AbstractChunk;
import de.kapsi.net.daap.chunks.ByteChunk;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SByteChunk
extends AbstractChunk
implements ByteChunk {
    private static final Log LOG = LogFactory.getLog((Class)(class$de$kapsi$net$daap$chunks$SByteChunk == null ? (class$de$kapsi$net$daap$chunks$SByteChunk = SByteChunk.class$("de.kapsi.net.daap.chunks.SByteChunk")) : class$de$kapsi$net$daap$chunks$SByteChunk));
    public static final int MIN_VALUE = -128;
    public static final int MAX_VALUE = 127;
    protected int value = 0;
    static /* synthetic */ Class class$de$kapsi$net$daap$chunks$SByteChunk;

    public SByteChunk(int type, String name, int value) {
        super(type, name);
        this.setValue(value);
    }

    public SByteChunk(String type, String name, int value) {
        super(type, name);
        this.setValue(value);
    }

    public void setValue(int value) {
        this.value = SByteChunk.checkSByteRange(value);
    }

    public int getValue() {
        return this.value;
    }

    public static int checkSByteRange(int value) throws IllegalArgumentException {
        if ((value < -128 || value > 127) && LOG.isErrorEnabled()) {
            LOG.error((Object)("Value is outside of signed byte range: " + value));
        }
        return value;
    }

    public int getType() {
        return 2;
    }

    public String toString(int indent) {
        return SByteChunk.indent(indent) + this.name + "(" + this.getContentCodeString() + "; byte)=" + this.getValue();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

