/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.chunks;

import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.chunks.AbstractChunk;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class VersionChunk
extends AbstractChunk {
    private static final Log LOG = LogFactory.getLog((Class)(class$de$kapsi$net$daap$chunks$VersionChunk == null ? (class$de$kapsi$net$daap$chunks$VersionChunk = VersionChunk.class$("de.kapsi.net.daap.chunks.VersionChunk")) : class$de$kapsi$net$daap$chunks$VersionChunk));
    public static final long MIN_VALUE = 0L;
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    protected int version = 0;
    static /* synthetic */ Class class$de$kapsi$net$daap$chunks$VersionChunk;

    public VersionChunk(int type, String name, long value) {
        super(type, name);
        this.setValue(value);
    }

    public VersionChunk(String type, String name, long value) {
        super(type, name);
        this.setValue(value);
    }

    protected VersionChunk(String type, String name, int majorVersion, int minorVersion, int microVersion) {
        this(type, name, (long)DaapUtil.toVersion(majorVersion, minorVersion, microVersion));
    }

    public void setValue(long version) {
        this.version = (int)VersionChunk.checkVersionRange(version);
    }

    public long getValue() {
        return (long)this.version & 0xFFFFFFFFL;
    }

    public void setMajorVersion(int majorVersion) {
        long version = this.getValue() & 0xFFFFL;
        this.setValue(version |= (long)((majorVersion & 0xFFFF) << 16));
    }

    public void setMinorVersion(int minorVersion) {
        long version = this.getValue() & 0xFFFF00FFL;
        this.setValue(version |= (long)((minorVersion & 0xFF) << 8));
    }

    public void setMicroVersion(int microVersion) {
        long version = this.getValue() & 0xFFFFFF00L;
        this.setValue(version |= (long)(microVersion & 0xFF));
    }

    public int getMajorVersion() {
        return (int)(this.getValue() >> 16 & 0xFFFFL);
    }

    public int getMinorVersion() {
        return (int)(this.getValue() >> 8 & 0xFFL);
    }

    public int getMicroVersion() {
        return (int)(this.getValue() & 0xFFL);
    }

    public static long checkVersionRange(long value) throws IllegalArgumentException {
        if ((value < 0L || value > 0xFFFFFFFFL) && LOG.isErrorEnabled()) {
            LOG.error((Object)("Value is outside of Version range: " + value));
        }
        return value;
    }

    public int getType() {
        return 11;
    }

    public String toString(int indent) {
        return VersionChunk.indent(indent) + this.name + "(" + this.getContentCodeString() + "; version)=" + this.getMajorVersion() + "." + this.getMinorVersion() + "." + this.getMicroVersion();
    }

    public static final int getMajorVersion(int version) {
        return (version & 0xFFFF0000) >> 16;
    }

    public static final int getMinorVersion(int version) {
        return (version & 0xFF00) >> 8;
    }

    public static final int getMicroVersion(int version) {
        return version & 0xFF;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

