/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.jdesktop.jdic.browser.MsgClient;
import org.jdesktop.jdic.browser.NativeEventData;
import org.jdesktop.jdic.browser.WebBrowser;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.JdicManager;

class NativeEventThread
extends Thread {
    private Vector webBrowsers = new Vector();
    private Vector nativeEvents = new Vector();
    private Process nativeBrowser;
    boolean eventRetBool;
    String eventRetString;
    MsgClient messenger = new MsgClient();

    NativeEventThread() {
        super("EventThread");
    }

    void attachWebBrowser(WebBrowser webBrowser) {
        int n = webBrowser.getInstanceNum();
        if (n >= this.webBrowsers.size()) {
            this.webBrowsers.setSize(n + 1);
        }
        this.webBrowsers.set(n, webBrowser);
    }

    public void run() {
        try {
            String string;
            if (WebBrowserUtil.getEmbedBinaryName() == null) {
                this.setBrowsersInitFailReason("The embedded browser binary is not set.");
                WebBrowserUtil.trace("The embedded browser binary is not set, system exit.");
                return;
            }
            String string2 = System.getProperty("java.vm.vendor");
            if (WebBrowserUtil.getEmbedBinaryName().endsWith("IeEmbed.exe") && string2.startsWith("Sun")) {
                WebBrowserUtil.nativeSetEnv();
            }
            final String string3 = new File(string = JdicManager.getManager().getBinaryPath() + File.separator + WebBrowserUtil.getEmbedBinaryName()).exists() ? string : WebBrowserUtil.getEmbedBinaryName();
            WebBrowserUtil.trace("Executing " + string3 + " -port=" + this.messenger.getPort());
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    NativeEventThread.this.nativeBrowser = Runtime.getRuntime().exec(new String[]{string3, "-port=" + NativeEventThread.this.messenger.getPort()});
                    new StreamGobbler(NativeEventThread.this.nativeBrowser.getErrorStream()).start();
                    new StreamGobbler(NativeEventThread.this.nativeBrowser.getInputStream()).start();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setBrowsersInitFailReason("Can't find the native embedded browser.");
            System.out.println("Can't execute the native embedded browser. Error message: " + privilegedActionException.getCause().getMessage());
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    NativeEventThread.this.messenger.connect();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.out.println("Can't connect to the native embedded browser. Error message: " + privilegedActionException.getCause().getMessage());
            this.setBrowsersInitFailReason("Can't connect to the native embedded browser.");
            return;
        }
        while (true) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n = this.nativeBrowser.exitValue();
                WebBrowserUtil.trace("Native embedded browser died.");
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    this.processEventsFromJava();
                }
                catch (Exception exception) {
                    WebBrowserUtil.trace("Exception occured when processEvent: " + exception.getMessage());
                    return;
                }
                try {
                    this.messenger.portListening();
                    this.processMessageFromNative(this.messenger.getMessage());
                }
                catch (Exception exception) {
                    WebBrowserUtil.trace("Exception occured when portListening: " + exception.getMessage());
                    return;
                }
            }
        }
    }

    private WebBrowser getWebBrowserFromInstance(int n) {
        try {
            return (WebBrowser)this.webBrowsers.get(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWebBrowser(int n) {
        WebBrowser webBrowser = this.getWebBrowserFromInstance(n);
        if (null != webBrowser) {
            WebBrowser webBrowser2 = webBrowser;
            synchronized (webBrowser2) {
                webBrowser.notify();
            }
        }
    }

    private void processEventsFromJava() {
        int n = this.nativeEvents.size();
        for (int i = 0; i < n; ++i) {
            NativeEventData nativeEventData = (NativeEventData)this.nativeEvents.get(i);
            if (!this.processEventFromJava(nativeEventData)) continue;
            this.nativeEvents.removeElementAt(i);
            break;
        }
    }

    private boolean processEventFromJava(NativeEventData nativeEventData) {
        WebBrowser webBrowser = this.getWebBrowserFromInstance(nativeEventData.instance);
        if (null == webBrowser) {
            return true;
        }
        if (!webBrowser.isInitialized() && nativeEventData.type != 0 && nativeEventData.type != 1) {
            return false;
        }
        WebBrowserUtil.trace("Process event to native browser: " + nativeEventData.instance + ", " + nativeEventData.type + ", ");
        String string = nativeEventData.instance + "," + nativeEventData.type + ",";
        switch (nativeEventData.type) {
            case 0: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.messenger.sendMessage(string);
                break;
            }
            case 3: {
                this.messenger.sendMessage(string);
                break;
            }
            case 1: {
                int n = webBrowser.getNativeWindow();
                if (0 == n) {
                    WebBrowserUtil.trace("Can't get the JAWT native window handler.");
                    break;
                }
                string = string + n;
                this.messenger.sendMessage(string);
                break;
            }
            case 4: {
                string = string + nativeEventData.rectValue.x + "," + nativeEventData.rectValue.y + "," + nativeEventData.rectValue.width + "," + nativeEventData.rectValue.height;
                this.messenger.sendMessage(string);
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 17: {
                string = string + nativeEventData.stringValue;
                this.messenger.sendMessage(string);
            }
        }
        return true;
    }

    static NativeEventData parseMessageString(String string) {
        if (null == string || 0 == string.length()) {
            return null;
        }
        int n = -1;
        String string2 = null;
        int n2 = string.indexOf(",", 0);
        int n3 = Integer.parseInt(string.substring(0, n2));
        int n4 = string.indexOf(",", n2 + 1);
        if (n4 < 0) {
            n = Integer.parseInt(string.substring(n2 + 1));
        } else {
            n = Integer.parseInt(string.substring(n2 + 1, n4));
            if (n4 + 1 < string.length()) {
                string2 = string.substring(n4 + 1);
            }
        }
        return new NativeEventData(n3, n, string2);
    }

    private void processMessageFromNative(String string) {
        NativeEventData nativeEventData = NativeEventThread.parseMessageString(string);
        if (nativeEventData == null) {
            return;
        }
        WebBrowserUtil.trace("Process event from native browser: " + nativeEventData.instance + ", " + nativeEventData.type + ", " + nativeEventData.stringValue);
        if (3041 == nativeEventData.type) {
            this.setBrowsersInitFailReason(nativeEventData.stringValue);
            return;
        }
        if (nativeEventData.instance < 0) {
            return;
        }
        if (3021 == nativeEventData.type || 3061 == nativeEventData.type || 3063 == nativeEventData.type || 3044 == nativeEventData.type) {
            this.eventRetString = nativeEventData.stringValue;
            this.notifyWebBrowser(nativeEventData.instance);
            return;
        }
        final WebBrowser webBrowser = this.getWebBrowserFromInstance(nativeEventData.instance);
        if (null == webBrowser) {
            return;
        }
        if (3042 == nativeEventData.type) {
            webBrowser.setInitialized(true);
            webBrowser.setInitFailureMessage("");
            return;
        }
        final WebBrowserEvent webBrowserEvent = new WebBrowserEvent(webBrowser, nativeEventData.type, nativeEventData.stringValue);
        Runnable runnable = new Runnable(){

            public void run() {
                webBrowser.dispatchWebBrowserEvent(webBrowserEvent);
            }
        };
        try {
            SwingUtilities.invokeLater(runnable);
        }
        catch (Exception exception) {
            WebBrowserUtil.trace("Exception occured when invokeLater. Error message: " + exception.getMessage());
        }
    }

    synchronized void fireNativeEvent(int n, int n2) {
        this.nativeEvents.addElement(new NativeEventData(n, n2));
    }

    synchronized void fireNativeEvent(int n, int n2, Rectangle rectangle) {
        this.nativeEvents.addElement(new NativeEventData(n, n2, rectangle));
    }

    synchronized void fireNativeEvent(int n, int n2, String string) {
        this.nativeEvents.addElement(new NativeEventData(n, n2, string));
    }

    void setBrowsersInitFailReason(String string) {
        ((WebBrowser)this.webBrowsers.elementAt(0)).setInitFailureMessage(string);
    }

    class StreamGobbler
    extends Thread {
        InputStream is;

        StreamGobbler(InputStream inputStream) {
            this.is = inputStream;
        }

        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.is);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println("+++ Ctrace: " + string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

