/* _NVRM_COPYRIGHT_BEGIN_
 *
 * Copyright 2001-2002 by NVIDIA Corporation.  All rights reserved.  All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 *
 * _NVRM_COPYRIGHT_END_
 */

#include "nv-misc.h"
#include "os-interface.h"
#include "nv.h"
#include "nv-freebsd.h"


void* os_pci_init_handle(
    U008 bus,
    U008 slot,
    U008 function,
    U016 *vendor,
    U016 *device
)
{
    device_t dev;

    /*
     * Find a PCI device based on its address, and return a unique handle
     * to be used in subsequent calls to read from or write to the config
     * space of this device.
     */

    dev = pci_find_bsf(bus, slot, function);

    if (dev != NULL) {
        if (vendor)
            *vendor = pci_get_vendor(dev);
        if (device)
            *device = pci_get_device(dev);
    }

    return (void *) dev;
}

U008 os_pci_read_byte(
    void *handle,
    U008 offset
)
{
    return pci_read_config((device_t) handle, offset, 1);
}

U016 os_pci_read_word(
    void *handle,
    U008 offset
)
{
    return pci_read_config((device_t) handle, offset, 2);
}

U032 os_pci_read_dword(
    void *handle,
    U008 offset
)
{
    return pci_read_config((device_t) handle, offset, 4);
}

void os_pci_write_byte(
    void *handle,
    U008 offset,
    U008 value
)
{
    pci_write_config((device_t) handle, offset, value, 1);
}

void os_pci_write_word(
    void *handle,
    U008 offset,
    U016 value
)
{
    pci_write_config((device_t) handle, offset, value, 2);
}

void os_pci_write_dword(
    void *handle,
    U008 offset,
    U032 value
)
{
    pci_write_config((device_t) handle, offset, value, 4);
}

BOOL os_pci_device_present(
    U016 vendor,
    U016 device
)
{
    if (pci_find_device(vendor, device))
        return TRUE;
    return FALSE;
}

