/**********************************************************************
*
*  nvhw.h
*
*  Descripion  - Header file used for the common structures
*
*  Copyright (c) 2002-2003 NVIDIA Corporation
*
***********************************************************************
*/
#ifndef _NVHW_H_
#define _NVHW_H_

#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/delay.h>
#include <linux/signal.h>
#include <linux/sound.h>
#include <linux/slab.h>
#include <linux/soundcard.h>
#include <linux/pci.h>
#include <asm/io.h>
#include <asm/dma.h>
#include <linux/init.h>
#include <linux/poll.h>
#include <linux/spinlock.h>
#include <linux/smp_lock.h>
#include <linux/ac97_codec.h>
#include <linux/wrapper.h>
#include <asm/uaccess.h>
#include <asm/hardirq.h>

#include "chaninfo.h"

/*number of channels supported */
#define NR_HW_CH   3

/* maxinum number of AC97 codecs connected, AC97 2.0 defined 4 */
#define NR_AC97    2

#define DMABUF_DEFAULTORDER (16-PAGE_SHIFT)
#define DMABUF_MINORDER 1


#define Nvaudio_MODULE_NAME "Nvaudio"

#ifdef CONFIG_PM
#define PM_SUSPENDED(card) (card->pm_suspended)
#else
#define PM_SUSPENDED(card) (0)
#endif

struct Nvaudio_channel
{
    /* these sg guys should probably be allocated
    seperately as nocache. Must be 8 byte aligned */
    struct sg_item sg[SG_LEN];  /* 32*8 */
};


struct Nvaudio_card {

    unsigned int magic;
    /* We keep Nvaudio cards in a linked list */
    struct Nvaudio_card *next;

    spinlock_t lock;

    /* PCI device stuff */
    struct pci_dev * pci_dev;
    u16 pci_id;

#ifdef CONFIG_PM
    u16 pm_suspended;
    u32 pm_save_state[64/sizeof(u32)];
    int pm_saved_mixer_settings[SOUND_MIXER_NRDEVICES][NR_AC97];
#endif

    /* soundcore stuff */
    int dev_audio;

    /* structures for abstraction of hardware facilities, codecs, banks and channels*/
    struct ac97_codec *ac97_codec[NR_AC97];
    struct Nvaudio_state   *wavin;
    struct Nvaudio_state   *wavout;
    struct Nvaudio_state   *spout;

    /* for the prdlist physical addr */
    struct Nvaudio_channel *channel;
    dma_addr_t chandma;

    u16 ac97_features;
    u16 ac97_status;
    u16 channels;

    /* hardware resources */
    unsigned long iobase;
    unsigned long ac97base;
    u32 irq;

    /* Function support */
    u32 wavoutused;
    u32 wavinused;
    u32 spdifused;

    u32 ac3passthrough;
    u32 numchannels;

    int waveformat;
    /* We have a *very* long init time possibly, so use this to block */
    /* attempts to open our devices before we are ready (stops oops'es) */
    int initializing;
};

u16  Nvaudio_ac97_get(struct ac97_codec *dev, u8 reg);
void Nvaudio_ac97_set(struct ac97_codec *dev, u8 reg, u16 data);
int  alloc_dmabuf(struct Nvaudio_state *state);
void dealloc_dmabuf(struct Nvaudio_state *state);
int  prog_dmabuf(struct Nvaudio_state *state,unsigned rec);

#endif /* _NVHW_H_ */



