/**********************************************************************
*
*  chaninfo.h
*
*  Descripion  - Header file used for the common structures for the
*  channel information and waveformats
*
*  Copyright (c) 2002-2003 NVIDIA Corporation
*
***********************************************************************
*/
#ifndef _CHANINFO_H_
#define _CHANINFO_H_

#define ENABLE_SPDIF
//#define NV_DEBUG_REC
//#define NV_DEBUG_NORMAL
//#define NV_DEBUG_PLAY
//#define NV_DEBUG_SP
//#define DEBUG_INTERRUPTS
//#define DEBUG_MMAP


#define ADC_RUNNING    1
#define DAC_RUNNING    2
#define SPDIF_RUNNING  3


#define NVAUDIO_FMT_16BIT   1
#define NVAUDIO_FMT_STEREO  2
#define NVAUDIO_FMT_MASK    3

#define SPDIF_ON        0x0004
#define SURR_ON         0x0010
#define CENTER_LFE_ON   0x0020
#define VOL_MUTED       0x8000

#define SG_LEN     32

/* interrupts for a dma engine */
#define DMA_INT_FIFO        (1<<4)  /* fifo under/over flow */
#define DMA_INT_COMPLETE    (1<<3)  /* buffer read/write complete and ioc set */
#define DMA_INT_LVI         (1<<2)  /* last valid done */
#define DMA_INT_CELV        (1<<1)  /* last valid is current */
#define DMA_INT_DCH         (1)     /* DMA Controller Halted (happens on LVI interrupts) */
#define DMA_INT_MASK (DMA_INT_FIFO|DMA_INT_COMPLETE|DMA_INT_LVI)

/* interrupts for the whole chip */
#define INT_RCOM    (1<<15)
#define INT_SEC     (1<<11)
#define INT_PRI     (1<<10)
#define INT_MC      (1<<7)
#define INT_PO      (1<<6)
#define INT_PI      (1<<5)
#define INT_SP      (1<<4)
#define INT_MO      (1<<2)
#define INT_NI      (1<<1)
#define INT_GPI     (1<<0)
#define INT_MASK (INT_RCOM|INT_SEC|INT_PRI|INT_MC|INT_PO|INT_PI|INT_SP|INT_MO|INT_NI|INT_GPI)

/* AC97 registers */
enum {
    GLOB_CNT =  0x2c,       /* Global Control */
    GLOB_STA =  0x30,       /* Global Status */
    CAS      =  0x34        /* Codec Write Semaphore Register */
};

enum {
    OFF_BDBAR =   0x0,     /* Buffer Descriptor list Base Address */
    OFF_CIV   =   0x4,     /* Current Index Value */
    OFF_LVI   =   0x5,     /* Last Valid Index */
    OFF_SR    =   0x6,     /* Status Register */
    OFF_PICB  =   0x8,     /* Position In Current Buffer */
    OFF_PIV   =   0xa,     /* Prefetched Index Value */
    OFF_CR    =   0xb      /* Control Register */
};

struct sg_item {
#define BUSADDR_MASK    0xFFFFFFFE
    u32 busaddr;
#define CON_IOC         0x80000000 /* interrupt on completion */
#define CON_BUFPAD      0x40000000 /* pad underrun with last sample, else 0 */
#define CON_BUFLEN_MASK 0x0000ffff /* buffer length in samples */
    u32 control;
};

/* This struct keep all the dma info */
struct dmabuf {
        /* OSS buffer management stuff */
        void *rawbuf;
        dma_addr_t dma_handle;
        unsigned buforder;
        unsigned numfrag;
        unsigned fragshift;

        /* our buffer acts like a circular ring */
        unsigned hwptr;         /* where dma last started, updated by update_ptr */
        unsigned swptr;         /* where driver last clear/filled, updated by read/write */
        int count;              /* bytes to be consumed or been generated by dma machine */
        unsigned total_bytes;   /* total bytes dmaed by hardware */

        unsigned error;         /* number of over/underruns */
        wait_queue_head_t wait; /* put process on wait queue when no more space in buffer */

        /* redundant, but makes calculations easier */
        /* what the hardware uses */
        unsigned dmasize;
        unsigned fragsize;
        unsigned fragsamples;

        /* what we tell the user to expect */
        unsigned userfrags;
        unsigned userfragsize;

        /* OSS stuff */
        unsigned update_flag;
        unsigned ossfragsize;
        unsigned ossmaxfrags;
        unsigned subdivision;
    } dmabuf;

/* This structure keep all the info needed for each channel*/

struct Nvaudio_state{

    struct Nvaudio_card *card;  /* Card info */

    /* single open lock mechanism, only used for recording */
    struct semaphore open_sem;
    wait_queue_head_t open_wait;

    /* file mode */
    mode_t open_mode;


#ifdef CONFIG_PM
    unsigned int pm_saved_adc_rate;
    unsigned int pm_saved_dac_rate;
    unsigned int pm_saved_spdif_rate;
#endif

    /* wave sample stuff */
    unsigned int  rate;
    unsigned char fmt;
    unsigned char trigger;
    unsigned char enable;

    unsigned mapped:1;
    unsigned ready:1;
    unsigned spdif_enable:1;
    struct dmabuf  dmabuffer;

    spinlock_t lock;
};
#endif /* _CHANINFO_H_ */

