/**********************************************************************
*
*  nvhw.h
*
*  Descripion  - Header file used for the common structures
*
*  Copyright (c) 2002-2003 NVIDIA Corporation
*
***********************************************************************
*/
#ifndef _NVHW_H_
#define _NVHW_H_

#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/delay.h>
#include <linux/signal.h>
#include <linux/sound.h>
#include <linux/slab.h>
#include <linux/soundcard.h>
#include <linux/pci.h>
#include <asm/io.h>
#include <asm/dma.h>
#include <linux/init.h>
#include <linux/poll.h>
#include <linux/spinlock.h>
#include <linux/smp_lock.h>
#include <linux/ac97_codec.h>
#include <linux/wrapper.h>
#include <asm/uaccess.h>
#include <asm/hardirq.h>

#include "chaninfo.h"
#include "nvioctl.h"

/*number of channels supported */
#define NR_HW_CH   3

/* maxinum number of AC97 codecs connected, AC97 2.0 defined 4 */
#define NR_AC97    2

#define DMABUF_DEFAULTORDER (16-PAGE_SHIFT)
#define DMABUF_MINORDER 1


#define Nvaudio_MODULE_NAME "Nvaudio"

#ifdef CONFIG_PM
#define PM_SUSPENDED(card) (card->pm_suspended)
#else
#define PM_SUSPENDED(card) (0)
#endif

#define AC97REG_SIGMATEL_ID1       0x8384  // "ST"
#define AC97REG_SIGMATEL_ID2       0x7608  // "E"

#define AC97REG_ADI1885_ID1        0x4144  
#define AC97REG_ADI1885_ID2        0x5360  

#define AC97_ADI_MULTICHN          0x74

#define AC97_SIGMATEL_MULTICHN     0x74	/* Multi-Channel programming */
#define AC97_SIGMATEL_CIC1         0x76
#define AC97_SIGMATEL_CIC2         0x78


#define NO_SECONDARY               0x0
#define SIGMATEL_SECONDARY         0x1

#define REALTEK_CODEC              0x1
#define ADI_CODEC                  0x2
#define SIGMATEL_CODEC             0x3

#define CHANNEL_STEREO             0x2 
#define CHANNEL_QUAD               0x4
#define CHANNEL_51                 0x6

#define TRUE    1
#define FALSE   0
  
#define MAXVOLRANGE  32767
#define MINVOLRANGE -32768
#define RANGECHECK(val,min,max) { if (val < min) val = min; else if(val > max ) val=max;}

struct Nvaudio_channel
{
    /* these sg guys should probably be allocated
    seperately as nocache. Must be 8 byte aligned */
    struct sg_item sg[SG_LEN];  /* 32*8 */
};


struct Nvaudio_card {

    unsigned int magic;
    /* We keep Nvaudio cards in a linked list */
    struct Nvaudio_card *next;

    spinlock_t lock;

    /* PCI device stuff */
    struct pci_dev * pci_dev;
    u16 pci_id;

#ifdef CONFIG_PM
    u16 pm_suspended;
    u32 pm_save_state[64/sizeof(u32)];
    int pm_saved_mixer_settings[SOUND_MIXER_NRDEVICES][NR_AC97];
#endif

    /* soundcore stuff */
    int dev_audio;

    /* structures for abstraction of hardware facilities, codecs, banks and channels*/
    struct ac97_codec *ac97_codec[NR_AC97];
    struct Nvaudio_state   *wavin;
    struct Nvaudio_state   *wavout;
    struct Nvaudio_state   *spout;

    /* for the prdlist physical addr */
    struct Nvaudio_channel *channel;
    dma_addr_t chandma;

    u16 ac97_features;
    u16 ac97_status;
    u16 channels;

    /* hardware resources */
    unsigned long iobase;
    unsigned long ac97base;
    u32 irq;

    /* Function support */
    u32 wavoutused;
    u32 wavinused;
    u32 spdifused;

    u32 ac3passthrough;
    u32 numchannels;

    int waveformat;
    int codecsec;
    int spkrselect;
    int codecType;
    /* We have a *very* long init time possibly, so use this to block */
    /* attempts to open our devices before we are ready (stops oops'es) */
    int initializing;
};

u16  Nvaudio_ac97_get(struct ac97_codec *dev, u8 reg);
void Nvaudio_ac97_set(struct ac97_codec *dev, u8 reg, u16 data);
int  alloc_dmabuf(struct Nvaudio_state *state);
void dealloc_dmabuf(struct Nvaudio_state *state);
int  prog_dmabuf(struct Nvaudio_state *state,unsigned rec);
void Nvaudio_SetSpkrRegister(struct Nvaudio_card* card);
int Nvaudio_MultiChannel_volume(struct Nvaudio_card* card, int channel);
int Nvaudio_Recalfreespace(struct Nvaudio_card* card,int cnt);

/* Functions that help for mixdown */
u32  Nvaudio_MixDown5_1ToStereo(const char* pIn,void* pOut,int cnt,int carrylimit,int bSpdif);
u32  Nvaudio_MixDown5_1ToQuad(const char* pIn,void* pOut,int cnt,int carrylimit,int bSpdif);
u32  Nvaudio_MixDownQuadToStereo(const char* pIn,void* pOut,int cnt,int carrylimit,int bSpdif);
u32  Nvaudio_MixNormal(const char* pIn,void* pOut,int cnt,int carrylimit,int bSpdif);
u32  Nvaudio_UseLeftOverToQuad(short** pIn, short** pOut, int loopend,int carrylimit, u32* StartIndex, int bSpdif);
u32  Nvaudio_UseLeftOver(short** pIn, short** pOut, int loopend, int carrylimit, u32* StartIndex, int bSpdif, int ToQuad);
void Nvaudio_StoreLeftOver(int loop, int loopend, short** pSrc, int bSpdif);
long Nvaudio_MixDown( long channel, long center, long lfe, long schannel);

/* Function for Replicate the waves*/
u32 Nvaudio_UseLeftOverToStereo(short** pIn, short** pOut, int loopend,int carrylimit, u32* StartIndex);
u32  Nvaudio_ReplicateStereotoRear(const char* pIn,void* pOut,int cnt,int carrylimit);

#endif /* _NVHW_H_ */



