/**********************************************************************
*
*  nvioctl.h
*
*  Descripion  - Header file used for the common structures for the
*  ioctls used for apps and driver
*
*  Copyright (c) 2002-2003 NVIDIA Corporation
*
***********************************************************************
*/
#ifndef _NV_IOCTL_H_
#define _NV_IOCTL_H_

#define NV_SPKR_STEREO   2
#define NV_SPKR_QUAD     4
#define NV_SPKR_51       6
/*
 Common struct used to pass and get info between
 app and kernel
*/
struct nv_ioctl {
     unsigned long cmd;
     unsigned long val[4];
};

/* IOCTLS used to read and write the ac97 controller,
   codec registers and speaker configuration
   This is common between the application and driver
*/

#define NV_IOC_MAGIC 'n'
#define NV_IOCRESET   _IO(NV_IOC_MAGIC, 0)

#define NV_AC97CODEC_READ  _IOR(NV_IOC_MAGIC,1,struct nv_ioctl)
#define NV_AC97CODEC_WRITE _IOW(NV_IOC_MAGIC,2,struct nv_ioctl)
#define NV_AC97CON_READ    _IOR(NV_IOC_MAGIC,3,struct nv_ioctl)
#define NV_AC97CON_WRITE   _IOW(NV_IOC_MAGIC,4,struct nv_ioctl)
#define NV_SET_SPKRSELECT  _IOW(NV_IOC_MAGIC,5,struct nv_ioctl)
#define NV_GET_SPKRSELECT  _IOR(NV_IOC_MAGIC,6,struct nv_ioctl)
#define NV_SET_ANALOGOUT   _IOW(NV_IOC_MAGIC,7,struct nv_ioctl)
#define NV_GET_ANALOGOUT   _IOR(NV_IOC_MAGIC,8,struct nv_ioctl)
#define NV_SET_DIGITALOUT  _IOW(NV_IOC_MAGIC,9,struct nv_ioctl)
#define NV_GET_DIGITALOUT  _IOW(NV_IOC_MAGIC,10,struct nv_ioctl)

#define NV_IOC_HARDRESET   _IO(NV_IOC_MAGIC, 11)

#define NV_IOC_MAXNR  NV_IOC_HARDRESET


#endif /* _NV_IOCTL_H_ */

