/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.w3c.dom.DOMException;

public class AttrNSImpl
extends AttrImpl {
    static final long serialVersionUID = -781906615369795414L;
    static final String xmlnsURI = "http://www.w3.org/2000/xmlns/";
    static final String xmlURI = "http://www.w3.org/XML/1998/namespace";
    protected String namespaceURI;
    protected String localName;

    public AttrNSImpl() {
    }

    protected AttrNSImpl(CoreDocumentImpl ownerDocument, String namespaceURI, String qualifiedName) {
        super(ownerDocument, qualifiedName);
        this.setName(namespaceURI, qualifiedName);
    }

    private void setName(String namespaceURI, String qualifiedName) throws DOMException {
        int index = qualifiedName.indexOf(58);
        String string = this.namespaceURI = namespaceURI != null && namespaceURI.length() == 0 ? null : namespaceURI;
        if (index < 0) {
            Object prefix = null;
            this.localName = qualifiedName;
            if (this.ownerDocument().errorChecking && qualifiedName.equals("xmlns") && (namespaceURI == null || !namespaceURI.equals(xmlnsURI))) {
                throw new DOMException(14, "DOM003 Namespace error");
            }
        } else {
            String prefix = qualifiedName.substring(0, index);
            this.localName = qualifiedName.substring(index + 1);
            if (this.ownerDocument().errorChecking) {
                if (this.namespaceURI == null || this.localName.length() == 0 || this.localName.indexOf(58) >= 0) {
                    throw new DOMException(14, "DOM003 Namespace error");
                }
                if (prefix.equals("xml") ? !namespaceURI.equals(xmlURI) : (prefix.equals("xmlns") ? !namespaceURI.equals(xmlnsURI) : index == 0)) {
                    throw new DOMException(14, "DOM003 Namespace error");
                }
            }
        }
    }

    public AttrNSImpl(CoreDocumentImpl ownerDocument, String namespaceURI, String qualifiedName, String localName) {
        super(ownerDocument, qualifiedName);
        this.localName = localName;
        this.namespaceURI = namespaceURI;
    }

    protected AttrNSImpl(CoreDocumentImpl ownerDocument, String value) {
        super(ownerDocument, value);
    }

    void rename(String namespaceURI, String qualifiedName) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.name = qualifiedName;
        this.setName(namespaceURI, qualifiedName);
    }

    public void setValues(CoreDocumentImpl ownerDocument, String namespaceURI, String qualifiedName, String localName) {
        AttrImpl.textNode = null;
        this.flags = 0;
        this.isSpecified(true);
        this.hasStringValue(true);
        super.setOwnerDocument(ownerDocument);
        this.localName = localName;
        this.namespaceURI = namespaceURI;
        this.name = qualifiedName;
        this.value = null;
    }

    public String getNamespaceURI() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.namespaceURI;
    }

    public String getPrefix() {
        int index;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return (index = this.name.indexOf(58)) < 0 ? null : this.name.substring(0, index);
    }

    public void setPrefix(String prefix) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument().errorChecking) {
            if (this.isReadOnly()) {
                throw new DOMException(7, "DOM001 Modification not allowed");
            }
            if (!CoreDocumentImpl.isXMLName(prefix)) {
                throw new DOMException(5, "DOM002 Illegal character");
            }
            if (this.namespaceURI == null || prefix.indexOf(58) >= 0) {
                throw new DOMException(14, "DOM003 Namespace error");
            }
            if (prefix != null && (prefix.equals("xmlns") ? !this.namespaceURI.equals(xmlnsURI) : (prefix.equals("xml") ? !this.namespaceURI.equals(xmlURI) : this.name.equals("xmlns")))) {
                throw new DOMException(14, "DOM003 Namespace error");
            }
        }
        this.name = prefix + ":" + this.localName;
    }

    public String getLocalName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.localName;
    }
}

