/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.netbeans.core.IDESettings;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListener;
import org.openide.util.WeakSet;

public class MiniStatusBar
extends JLabel {
    private static final String PROP_NODE_DESCRIPTION = "nodeDescription";
    private static final WeakSet loggedClasses = new WeakSet();
    private static boolean LOG_NODE_DESCRIPTION = Boolean.getBoolean("netbeans.log.node.description");
    private ExplorerManager mgr;
    private IDESettings ideSettings;
    private PropL propL;
    static /* synthetic */ Class class$org$netbeans$core$IDESettings;
    static /* synthetic */ Class class$org$openide$nodes$FilterNode;

    public MiniStatusBar(ExplorerManager mgr) {
        this.mgr = mgr;
        this.ideSettings = (IDESettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = MiniStatusBar.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
        this.initialize();
        this.updateDescription();
        this.propL = new PropL();
        mgr.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.propL, (Object)mgr));
        this.ideSettings.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.propL, (Object)this.ideSettings));
    }

    private void initialize() {
        this.setOpaque(false);
        this.setEnabled(true);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getDefaults().getColor("control")), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, UIManager.getDefaults().getColor("controlHighlight")), BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlDkShadow")))));
    }

    private void setNodeDescription(String desc) {
        if (desc != null) {
            if (desc.startsWith("<html>")) {
                this.setText("<html>&nbsp;" + desc.substring(6));
            } else {
                this.setText(" " + desc);
            }
        } else {
            this.setText(" ");
        }
    }

    private void updateDescription() {
        boolean state = this.ideSettings.getMiniStatusBarState();
        if (state) {
            Node[] n = this.mgr.getSelectedNodes();
            int i = 0;
            while (i < n.length) {
                String desc = this.getNodeDesc(n[i]);
                if (desc != null) {
                    this.setNodeDescription(desc);
                    return;
                }
                ++i;
            }
            this.setNodeDescription(null);
        } else {
            this.setNodeDescription(null);
        }
        if (this.isVisible() != state) {
            this.setVisible(state);
            if (this.getRootPane() != null) {
                this.getRootPane().revalidate();
            }
        }
    }

    private String getNodeDesc(Node n) {
        String nodeDesc = (String)n.getValue(PROP_NODE_DESCRIPTION);
        if (nodeDesc == null && (nodeDesc = n.getShortDescription()) != null && nodeDesc.equals(n.getDisplayName())) {
            nodeDesc = null;
        }
        this.logDescription(n, nodeDesc);
        return nodeDesc;
    }

    private void logDescription(Node n, String desc) {
        if (!LOG_NODE_DESCRIPTION) {
            return;
        }
        String className = this.getNodeClass(n).getName();
        if (!loggedClasses.add((Object)className)) {
            return;
        }
        if (desc == null || desc.equals(n.getDisplayName())) {
            String logMessage = MessageFormat.format("Node description of {0}: Warning! No description is provided. More info at http://openide.netbeans.org/unbranded-source/browse/~checkout~/openide/api/doc/org/openide/doc-files/upgrade.html", className);
            ErrorManager.getDefault().log(16, logMessage);
        } else {
            String logMessage = MessageFormat.format("Node description of {0}: {1} More info at http://openide.netbeans.org/unbranded-source/browse/~checkout~/openide/api/doc/org/openide/doc-files/upgrade.html", className, desc);
            ErrorManager.getDefault().log(16, logMessage);
        }
    }

    private Class getNodeClass(Node n) {
        if (n instanceof FilterNode) {
            try {
                Method getOriginal = (class$org$openide$nodes$FilterNode == null ? (class$org$openide$nodes$FilterNode = MiniStatusBar.class$("org.openide.nodes.FilterNode")) : class$org$openide$nodes$FilterNode).getDeclaredMethod("getOriginal", new Class[0]);
                ((AccessibleObject)getOriginal).setAccessible(true);
                try {
                    n = (Node)getOriginal.invoke((Object)n, new Object[0]);
                    Object var4_4 = null;
                    ((AccessibleObject)getOriginal).setAccessible(false);
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    ((AccessibleObject)getOriginal).setAccessible(false);
                    throw throwable;
                }
                return this.getNodeClass(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n.getClass();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PropL
    implements PropertyChangeListener {
        private PropL() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                MiniStatusBar.this.updateDescription();
            } else if ("mini_status_bar_state".equals(evt.getPropertyName())) {
                MiniStatusBar.this.updateDescription();
            }
        }
    }
}

