/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import org.netbeans.core.AutomountSupport;
import org.netbeans.core.projects.SessionManager;
import org.netbeans.core.projects.TrivialProjectManager;
import org.netbeans.core.windows.PersistenceManager;
import org.netbeans.modules.projects.CurrentProjectNode;
import org.netbeans.modules.projects.ProjectDataNode;
import org.netbeans.modules.projects.ProjectDataObject;
import org.netbeans.modules.projects.ProjectRootFilterNode;
import org.netbeans.modules.projects.content.DiffSet;
import org.netbeans.modules.projects.content.OptionProcessor;
import org.netbeans.modules.projects.content.ProjectContent;
import org.netbeans.modules.projects.content.ProjectErrorManager;
import org.netbeans.modules.projects.content.SettingsSet;
import org.netbeans.modules.projects.content.XMLProjectContent;
import org.openide.ErrorManager;
import org.openide.ServiceType;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.ProjectCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;

public class PSupport
implements ProjectCookie {
    static final long serialVersionUID = -8907373672945248595L;
    static final String GLOBAL_METHOD_NAME = "isGlobal";
    private static final String EA_SAVE = "Project-Save";
    private static final String EA_DELETE = "Project-DeleteFiles";
    private static final boolean DELETE_DEFAULT = false;
    public static final int SAVE_CONTROL_PANEL = 1;
    public static final int SAVE_LOADERS = 2;
    public static final int SAVE_MODULES = 4;
    public static final int SAVE_REPOSITORY = 8;
    public static final int SAVE_SERVICES = 16;
    public static final int SAVE_WINDOW_MANAGER = 32;
    public static final int SAVE_ALL = 63;
    static final int SAVE_ALL_NEW = 4;
    public static final int CLEAR_REPOSITORY = 1024;
    public static final int INFO_OPEN_START = 1;
    public static final int INFO_OPEN_DONE = 2;
    public static final int INFO_OPEN_ERR = 3;
    public static final int INFO_SAVE_START = 4;
    public static final int INFO_SAVE_DONE = 5;
    public static final int INFO_SAVE_ERR = 6;
    public static final int INFO_CONTROL_PANEL = 1;
    public static final int INFO_LOADERS = 2;
    public static final int INFO_MODULES = 4;
    public static final int INFO_REPOSITORY = 8;
    public static final int INFO_SERVICES = 16;
    public static final int INFO_WINDOW_MANAGER = 32;
    private static final String ATTR_GLOBAL = "global";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_TRANSIENT = "transient";
    private static transient ProjectContent globalContent = null;
    private static transient ProjectErrorManager pem;
    private transient ProjectContent projectContent = null;
    private transient Node rootNode = null;
    private ProjectDataObject dobj;
    private transient FileSystem projectLayer = null;
    static /* synthetic */ Class class$org$netbeans$core$projects$TrivialProjectManager;
    static /* synthetic */ Class class$org$netbeans$modules$projects$PSupport;
    static /* synthetic */ Class class$org$openide$options$SystemOption;
    static /* synthetic */ Class class$org$openide$ServiceType$Registry;

    public static DataFolder getProjectsFolder() {
        FileObject f = Repository.getDefault().getDefaultFileSystem().findResource("Projects");
        return f == null ? null : DataFolder.findFolder((FileObject)f);
    }

    public static void openProject(ProjectCookie project) throws IOException {
        PSupport.saveAsLastProject(project);
        TrivialProjectManager tpm = (TrivialProjectManager)Lookup.getDefault().lookup(class$org$netbeans$core$projects$TrivialProjectManager == null ? (class$org$netbeans$core$projects$TrivialProjectManager = PSupport.class$("org.netbeans.core.projects.TrivialProjectManager")) : class$org$netbeans$core$projects$TrivialProjectManager);
        tpm.load();
    }

    public PSupport(ProjectDataObject dobj) {
        this.dobj = dobj;
        try {
            Object attr = dobj.getPrimaryFile().getAttribute(EA_DELETE);
            if (attr != null) {
                dobj.getPrimaryFile().setAttribute(EA_DELETE, null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Node projectDesktop() {
        return CurrentProjectNode.getDefault();
    }

    public void projectClose() throws IOException {
        this.projectContent = null;
    }

    public void projectOpen() throws IOException {
        StatusDisplayer sts = StatusDisplayer.getDefault();
        Node oldProjectNode = CurrentProjectNode.getDefault().getOrig();
        Node newProjectNode = this.getProjectNode();
        sts.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$PSupport == null ? (class$org$netbeans$modules$projects$PSupport = PSupport.class$("org.netbeans.modules.projects.PSupport")) : class$org$netbeans$modules$projects$PSupport), (String)"MSG_OpenProject", (Object)this.getProjectDO().getName()));
        CurrentProjectNode.getDefault().firePropChange("nb-projects-beforeOpenProject", oldProjectNode == CurrentProjectNode.NO_PROJECT_NODE ? null : oldProjectNode.getName(), newProjectNode.getName());
        CurrentProjectNode.getDefault().set(newProjectNode);
        try {
            block4: {
                try {
                    SessionManager.getDefault().setProjectLayer(this.getProjectDO().getProjectLayerDir());
                    int save = this.getSave();
                    if (save == 4) break block4;
                    this.openOldProject(save);
                }
                catch (IOException e) {
                    CurrentProjectNode.getDefault().set(oldProjectNode);
                    throw e;
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            CurrentProjectNode.getDefault().firePropChange("nb-projects-afterOpenProject", oldProjectNode == CurrentProjectNode.NO_PROJECT_NODE ? null : oldProjectNode.getName(), newProjectNode.getName());
            sts.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$PSupport == null ? (class$org$netbeans$modules$projects$PSupport = PSupport.class$("org.netbeans.modules.projects.PSupport")) : class$org$netbeans$modules$projects$PSupport), (String)"MSG_OpenProjectDone", (Object)this.getProjectDO().getName()));
            throw throwable;
        }
        CurrentProjectNode.getDefault().firePropChange("nb-projects-afterOpenProject", oldProjectNode == CurrentProjectNode.NO_PROJECT_NODE ? null : oldProjectNode.getName(), newProjectNode.getName());
        sts.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$PSupport == null ? (class$org$netbeans$modules$projects$PSupport = PSupport.class$("org.netbeans.modules.projects.PSupport")) : class$org$netbeans$modules$projects$PSupport), (String)"MSG_OpenProjectDone", (Object)this.getProjectDO().getName()));
    }

    public void projectSave() throws IOException {
        PersistenceManager.getDefault().writeXMLWaiting();
        int save = this.getSave();
        save &= 0xFFFFFFFE;
        save &= 0xFFFFFFEF;
        save &= 0xFFFFFFF7;
        save &= 0xFFFFFFDF;
        this.setSave(save &= 0xFFFFFFFD);
        this.cleanUpFolder(this.getProjectDO());
        DataFolder projects = PSupport.getProjectsFolder();
        DataObject[] ch = projects.getChildren();
        save = 4;
        int i = 0;
        while (i < ch.length && save == 4) {
            if (ch[i] instanceof DataFolder) {
                Object attr = ch[i].getPrimaryFile().getAttribute(EA_SAVE);
                save |= attr == null ? 63 : (Integer)attr;
            }
            ++i;
        }
        if (save == 4) {
            this.cleanUpFolder(projects);
        }
    }

    public int getSave() {
        Integer save = (Integer)this.dobj.getPrimaryFile().getAttribute(EA_SAVE);
        int s = save != null ? save : 63;
        return s;
    }

    public void setSave(int save) throws IOException {
        this.dobj.getPrimaryFile().setAttribute(EA_SAVE, (Object)new Integer(save));
    }

    private Node getProjectNode() {
        if (this.rootNode == null) {
            DataFolder files = this.getProjectDO().getFilesFolder();
            Children children = files == null ? Children.LEAF : files.createNodeChildren(DataFilter.ALL);
            ProjectDataNode pdn = new ProjectDataNode(this.getProjectDO(), children, true);
            this.rootNode = new ProjectRootFilterNode(pdn);
        }
        return this.rootNode;
    }

    private ProjectDataObject getProjectDO() {
        return this.dobj;
    }

    private ProjectContent getProjectContent(ProjectErrorManager pem) {
        if (this.projectContent == null) {
            this.projectContent = new XMLProjectContent(this.getProjectDO(), PSupport.getGlobalProjectContent(pem), pem);
            this.projectContent.getRepository().setClear(false);
        }
        return this.projectContent;
    }

    private static ProjectContent getGlobalProjectContent(ProjectErrorManager pem) {
        if (globalContent == null) {
            globalContent = new XMLProjectContent(PSupport.getProjectsFolder(), null, pem);
            globalContent.getRepository().setClear(true);
        }
        return globalContent;
    }

    private void cleanUpFolder(DataFolder f) {
        DataObject[] ch = f.getChildren();
        int i = 0;
        while (i < ch.length) {
            if (!(ch[i] instanceof DataFolder) && !(ch[i] instanceof DataShadow)) {
                try {
                    ch[i].delete();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            ++i;
        }
    }

    private void openOldProject(int save) {
        ProjectErrorManager pem = new ProjectErrorManager();
        pem.clear();
        ProjectContent project = this.getProjectContent(pem);
        OptionProcessor.Set cpop = new OptionProcessor.Set();
        OptionProcessor.Set lpop = new OptionProcessor.Set();
        if ((save & 8) != 0) {
            this.updateRepository(pem);
        }
        if ((save & 2) != 0) {
            ProjectContent pc = project;
            while (pc != null) {
                SettingsSet lp = pc.getLoaderPool();
                lp.read(lpop);
                lpop.addAll(lp.getObjects());
                pc = pc.getSuperProject();
            }
        }
        if ((save & 1) != 0) {
            Lookup.Result r = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$options$SystemOption == null ? (class$org$openide$options$SystemOption = PSupport.class$("org.openide.options.SystemOption")) : class$org$openide$options$SystemOption));
            Collection c = r.allInstances();
            ProjectContent pc = project;
            while (pc != null) {
                SettingsSet cp = pc.getControlPanel();
                cp.read(cpop);
                cpop.addAll(cp.getObjects());
                pc = pc.getSuperProject();
            }
        }
        if ((save & 0x10) != 0) {
            this.updateServices(pem);
        }
        AutomountSupport.initialize().waitFinished();
        NbMarshalledObject nbo = null;
        ProjectContent pc = project;
        while (pc != null) {
            nbo = pc.getWindowManager();
            if (nbo != null) break;
            pc = pc.getSuperProject();
        }
        if ((save & 0x20) != 0) {
            this.updateWindowManager(nbo, pem);
        }
        pem.show();
    }

    private void updateSettingsSet(SettingsSet set, SharedClassObject[] scos) {
        set.clear();
        int i = 0;
        while (i < scos.length) {
            set.add(scos[i]);
            ++i;
        }
    }

    private SharedClassObject[] getProjectObjects(SharedClassObject[] scos) {
        int i = 0;
        int j = 0;
        while (i < scos.length) {
            if (this.isProjectObject(scos[i].getClass(), scos[i], false)) {
                ++j;
            }
            ++i;
        }
        SharedClassObject[] objs = new SharedClassObject[j];
        i = 0;
        j = 0;
        while (i < scos.length) {
            if (this.isProjectObject(scos[i].getClass(), scos[i], false)) {
                objs[j++] = scos[i];
            }
            ++i;
        }
        return objs;
    }

    private boolean isProjectObject(Class clazz, Object obj, boolean defaultValue) {
        try {
            if (this.hasGlobalAtrributeInBeanInfo(clazz)) {
                return !this.isGlobalFromBeanInfo(clazz);
            }
            if (obj == null) {
                return defaultValue;
            }
            Method m = clazz.getMethod(GLOBAL_METHOD_NAME, new Class[0]);
            ((AccessibleObject)m).setAccessible(true);
            Boolean b = (Boolean)m.invoke(obj, new Object[0]);
            return b == false;
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    private boolean hasGlobalAtrributeInBeanInfo(Class clazz) {
        try {
            BeanInfo b = Introspector.getBeanInfo(clazz);
            if (b != null) {
                Object v;
                BeanDescriptor bd = b.getBeanDescriptor();
                if (bd != null && (v = bd.getValue(ATTR_GLOBAL)) != null) {
                    return true;
                }
                BeanInfo[] infos = b.getAdditionalBeanInfo();
                if (infos != null) {
                    int i = 0;
                    while (i < infos.length) {
                        Object v2;
                        BeanDescriptor bd1 = infos[i].getBeanDescriptor();
                        if (bd1 != null && (v2 = bd1.getValue(ATTR_GLOBAL)) != null) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return false;
    }

    private boolean isGlobalFromBeanInfo(Class clazz) {
        try {
            BeanInfo b = Introspector.getBeanInfo(clazz);
            if (b != null) {
                Object v;
                BeanDescriptor bd = b.getBeanDescriptor();
                if (bd != null && (v = bd.getValue(ATTR_GLOBAL)) instanceof Boolean) {
                    return (Boolean)v;
                }
                BeanInfo[] infos = b.getAdditionalBeanInfo();
                if (infos != null) {
                    int i = 0;
                    while (i < infos.length) {
                        Object v2;
                        BeanDescriptor bd1 = infos[i].getBeanDescriptor();
                        if (bd1 != null && (v2 = bd1.getValue(ATTR_GLOBAL)) instanceof Boolean) {
                            return (Boolean)v2;
                        }
                        ++i;
                    }
                }
            }
        }
        catch (IntrospectionException ie) {
            ErrorManager.getDefault().notify(4096, (Throwable)ie);
        }
        throw new IllegalArgumentException("Trying to get a value from beaninfo but the value is not there");
    }

    private String versionFromBeanInfo(Class clazz) {
        try {
            BeanInfo b = Introspector.getBeanInfo(clazz);
            if (b != null) {
                Object v;
                BeanDescriptor bd = b.getBeanDescriptor();
                if (bd != null && (v = bd.getValue(ATTR_VERSION)) instanceof String) {
                    return (String)v;
                }
                BeanInfo[] infos = b.getAdditionalBeanInfo();
                if (infos != null) {
                    int i = 0;
                    while (i < infos.length) {
                        Object v2;
                        BeanDescriptor bd1 = infos[i].getBeanDescriptor();
                        if (bd1 != null && (v2 = bd1.getValue(ATTR_VERSION)) instanceof String) {
                            return (String)v2;
                        }
                        ++i;
                    }
                }
            }
        }
        catch (IntrospectionException ie) {
            ErrorManager.getDefault().notify(4096, (Throwable)ie);
        }
        return null;
    }

    private boolean isTransientFromBeanInfo(Class clazz) {
        try {
            BeanInfo b = Introspector.getBeanInfo(clazz);
            if (b != null) {
                Object v;
                BeanDescriptor bd = b.getBeanDescriptor();
                if (bd != null && (v = bd.getValue(ATTR_TRANSIENT)) instanceof Boolean) {
                    return (Boolean)v;
                }
                BeanInfo[] infos = b.getAdditionalBeanInfo();
                if (infos != null) {
                    int i = 0;
                    while (i < infos.length) {
                        Object v2;
                        BeanDescriptor bd1 = infos[i].getBeanDescriptor();
                        if (bd1 != null && (v2 = bd1.getValue(ATTR_TRANSIENT)) instanceof Boolean) {
                            return (Boolean)v2;
                        }
                        ++i;
                    }
                }
            }
        }
        catch (IntrospectionException ie) {
            ErrorManager.getDefault().notify(4096, (Throwable)ie);
        }
        return false;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.dobj == null && stream instanceof CompatibilityStream) {
            this.dobj = ((CompatibilityStream)((Object)stream)).getDataObject();
            if (this.dobj == null || !(this.dobj instanceof ProjectDataObject) || !this.dobj.getPrimaryFile().isValid()) {
                this.dobj = ProjectDataObject.createDefaultProject();
            }
        } else if (!(this.dobj == null || this.dobj instanceof ProjectDataObject && this.dobj.getPrimaryFile().isValid())) {
            this.dobj = ProjectDataObject.createDefaultProject();
        }
    }

    private Object readResolve() throws ObjectStreamException {
        FileObject fo;
        PSupport project = this;
        if (this.dobj == null && (fo = PSupport.getLastProjectFile()) != null) {
            try {
                CompatibilityStream ois = new CompatibilityStream(new BufferedInputStream(fo.getInputStream(), 16384));
                project = (PSupport)((ObjectInputStream)((Object)ois)).readObject();
            }
            catch (IOException ex) {
                InvalidObjectException ioex = new InvalidObjectException("Cannot resolve object.");
                ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                InvalidObjectException ioex = new InvalidObjectException("Cannot resolve object.");
                ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)ex);
            }
        }
        return project;
    }

    private static FileObject getLastProjectFile() {
        FileSystem def = Repository.getDefault().getDefaultFileSystem();
        return def.find("", "project", "last");
    }

    private static void saveAsLastProject(ProjectCookie project) throws IOException {
        PSupport.saveObject(PSupport.getLastProjectFile(), project, false);
    }

    private void updateWindowManager(NbMarshalledObject nbo, ProjectErrorManager pem) {
        try {
            if (nbo != null) {
                nbo.get();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable th) {
            pem.annotate(5, "Error deserializing window system.", th);
        }
    }

    private void updateRepository(ProjectErrorManager pem) {
        Stack<DiffSet> stack = new Stack<DiffSet>();
        LinkedList<String> list = new LinkedList<String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        DiffSet diffset = null;
        ProjectContent pc = this.getProjectContent(pem);
        while (pc != null) {
            diffset = pc.getRepository();
            if (pc == this.getProjectContent(pem) && "1.0".equals(diffset.getVersion())) {
                diffset.setClear(false);
            }
            stack.push(diffset);
            if (diffset.isClear()) break;
            pc = pc.getSuperProject();
        }
        Repository repository = Repository.getDefault();
        if (diffset != null) {
            Iterator it;
            if (!diffset.isClear()) {
                Enumeration en = repository.fileSystems();
                while (en.hasMoreElements()) {
                    FileSystem fs = (FileSystem)en.nextElement();
                    if (fs.isDefault()) continue;
                    String fsname = fs.getSystemName();
                    list.add(fsname);
                    map.put(fsname, fs);
                }
            }
            while (!stack.empty()) {
                Object obj;
                diffset = (DiffSet)stack.pop();
                it = diffset.removedItems().iterator();
                while (it.hasNext()) {
                    obj = it.next();
                    list.remove(obj);
                    map.remove(obj);
                }
                it = diffset.addedItems().iterator();
                while (it.hasNext()) {
                    obj = it.next();
                    if (list.contains(obj)) continue;
                    list.add((String)obj);
                    map.put((String)obj, diffset.addedItem((String)obj));
                }
            }
            this.clearRepository();
            it = list.iterator();
            while (it.hasNext()) {
                FileSystem fs;
                String fsname = (String)it.next();
                if (repository.findFileSystem(fsname) != null || (fs = (FileSystem)map.get(fsname)) instanceof LocalFileSystem && fsname.indexOf("{netbeans.user}") == 0 && repository.findFileSystem(fsname = ((LocalFileSystem)fs).getRootDirectory().getAbsolutePath().replace(File.separatorChar, '/')) != null || fs == null) continue;
                repository.addFileSystem(fs);
            }
        }
    }

    private void clearRepository() {
        Repository repository = Repository.getDefault();
        Enumeration en = repository.fileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            if (fs.isDefault() || !this.isProjectObject(fs.getClass(), fs, true)) continue;
            repository.removeFileSystem(fs);
        }
    }

    private void updateServices(ProjectErrorManager pem) {
        Stack<DiffSet> stack = new Stack<DiffSet>();
        LinkedList<String> names = new LinkedList<String>();
        LinkedList<ServiceType> services = new LinkedList<ServiceType>();
        ProjectContent pc = this.getProjectContent(pem);
        while (pc != null) {
            stack.push(pc.getServices());
            pc = pc.getSuperProject();
        }
        if (!stack.isEmpty()) {
            Iterator i = null;
            ServiceType.Registry registry = (ServiceType.Registry)Lookup.getDefault().lookup(class$org$openide$ServiceType$Registry == null ? (class$org$openide$ServiceType$Registry = PSupport.class$("org.openide.ServiceType$Registry")) : class$org$openide$ServiceType$Registry);
            Enumeration en = registry.services();
            while (en.hasMoreElements()) {
                ServiceType st = (ServiceType)en.nextElement();
                names.add(st.getName());
            }
            i = ((AbstractList)stack).iterator();
            while (i.hasNext()) {
                String name;
                DiffSet ds = (DiffSet)i.next();
                Iterator j = ds.removedItems().iterator();
                while (j.hasNext()) {
                    name = (String)j.next();
                    names.remove(name);
                }
                j = ds.addedItems().iterator();
                while (j.hasNext()) {
                    name = (String)j.next();
                    if (names.contains(name)) continue;
                    names.add(name);
                }
            }
            i = names.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                ServiceType service = null;
                ProjectContent pc2 = this.getProjectContent(pem);
                while (pc2 != null) {
                    service = (ServiceType)pc2.getServices().addedItem(name);
                    if (null != service) break;
                    pc2 = pc2.getSuperProject();
                }
                if (service == null) {
                    service = registry.find(name);
                }
                if (service == null) continue;
                services.add(service);
            }
            registry.setServiceTypes(services);
        }
    }

    private static void saveObject(FileObject fout, Object o, boolean safe) throws IOException {
        FileLock lock = fout.lock();
        try {
            NbObjectOutputStream oos = new NbObjectOutputStream(fout.getOutputStream(lock));
            try {
                if (safe) {
                    NbObjectOutputStream.writeSafely((ObjectOutput)oos, (Object)o);
                } else {
                    oos.writeObject(o);
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                oos.close();
                throw throwable;
            }
            oos.close();
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            lock.releaseLock();
            throw throwable;
        }
        lock.releaseLock();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CompatibilityStream
    extends NbObjectInputStream {
        private ProjectDataObject dobj = null;

        public CompatibilityStream(InputStream in) throws IOException, StreamCorruptedException {
            super(in);
        }

        protected Object resolveObject(Object obj) throws IOException {
            if (obj instanceof ProjectDataObject) {
                this.dobj = (ProjectDataObject)((Object)obj);
            }
            return obj;
        }

        public ProjectDataObject getDataObject() {
            return this.dobj;
        }
    }
}

