/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import org.netbeans.modules.projects.CurrentProjectNode;
import org.netbeans.modules.projects.PSupport;
import org.netbeans.modules.projects.ProjectDataLoader;
import org.netbeans.modules.projects.ProjectDataNode;
import org.netbeans.modules.projects.SetMainClassAction;
import org.netbeans.modules.projects.settings.ProjectOption;
import org.openide.ErrorManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.cookies.CompilerCookie;
import org.openide.cookies.DebuggerCookie;
import org.openide.cookies.ExecCookie;
import org.openide.debugger.DebuggerException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;

public final class ProjectDataObject
extends DataFolder {
    static final long serialVersionUID = 3984322918015509710L;
    private static final String DEFAULT_PROJECT_NAME = "Default";
    private static final String PROJECT_LAYER_FOLDER = "system";
    static final String FILES_FOLDER = "Files";
    final PSupport support = new PSupport(this);
    private HashMap cookies = new HashMap(10);
    private static final Object LOCK = new Object();
    static /* synthetic */ Class class$org$netbeans$modules$projects$ProjectDataLoader;
    static /* synthetic */ Class class$org$openide$cookies$ProjectCookie;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Clean;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Build;
    static /* synthetic */ Class class$org$openide$cookies$DebuggerCookie;
    static /* synthetic */ Class class$org$openide$cookies$ExecCookie;
    static /* synthetic */ Class class$org$netbeans$modules$projects$ProjectDataObject;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$loaders$DataObject$Container;

    public static ProjectDataObject createProject(DataFolder f, String n) throws IOException {
        int i = n.lastIndexOf(46);
        String name = i <= 0 ? n : n.substring(0, i);
        String ext = i <= 0 ? null : n.substring(i + 1);
        return ProjectDataObject.createProjectImpl(f, name, ext, true);
    }

    private static ProjectDataObject createProjectImpl(DataFolder f, final String name, final String ext, boolean attr) throws IOException {
        final FileObject[] primary = new FileObject[1];
        final FileObject pf = f.getPrimaryFile();
        pf.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){
            static /* synthetic */ Class class$org$netbeans$modules$projects$ProjectDataLoader;

            public void run() throws IOException {
                String n = FileUtil.findFreeFileName((FileObject)pf, (String)name, (String)ext);
                if (ext != null && ext.length() > 0) {
                    n = n + "." + ext;
                }
                FileObject ff = FileUtil.createFolder((FileObject)pf, (String)n);
                if (ProjectDataObject.DEFAULT_PROJECT_NAME.equals(name)) {
                    try {
                        ff.setAttribute("SystemFileSystem.localizingBundle", (Object)"org.netbeans.modules.projects.Bundle");
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioe);
                    }
                }
                ProjectDataLoader pdl = (ProjectDataLoader)SharedClassObject.findObject((Class)(class$org$netbeans$modules$projects$ProjectDataLoader == null ? (class$org$netbeans$modules$projects$ProjectDataLoader = 1.class$("org.netbeans.modules.projects.ProjectDataLoader")) : class$org$netbeans$modules$projects$ProjectDataLoader), (boolean)true);
                DataLoaderPool.setPreferredLoader((FileObject)ff, (DataLoader)pdl);
                primary[0] = ff;
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        ProjectDataObject obj = ProjectDataObject.findPDO(primary[0]);
        if (attr) {
            obj.support.setSave(4);
        }
        return obj;
    }

    private static ProjectDataObject findPDO(FileObject f) throws IOException {
        DataObject obj = DataObject.find((FileObject)f);
        if (!(obj instanceof ProjectDataObject)) {
            try {
                ProjectDataLoader pdl = (ProjectDataLoader)SharedClassObject.findObject((Class)(class$org$netbeans$modules$projects$ProjectDataLoader == null ? (class$org$netbeans$modules$projects$ProjectDataLoader = ProjectDataObject.class$("org.netbeans.modules.projects.ProjectDataLoader")) : class$org$netbeans$modules$projects$ProjectDataLoader), (boolean)true);
                DataLoaderPool.setPreferredLoader((FileObject)f, (DataLoader)pdl);
                obj.setValid(false);
            }
            catch (Exception x) {
                ErrorManager.getDefault().notify(1, (Throwable)x);
            }
            obj = DataObject.find((FileObject)f);
            if (!(obj instanceof ProjectDataObject)) {
                throw new IOException("Project data object not recognized " + f.getPackageNameExt('/', '.'));
            }
        }
        return (ProjectDataObject)obj;
    }

    public static ProjectDataObject createDefaultProject() throws IOException {
        DataFolder projects = PSupport.getProjectsFolder();
        FileObject folder = projects.getPrimaryFile();
        FileObject fo = folder.getFileObject(DEFAULT_PROJECT_NAME);
        ProjectDataObject pdo = null;
        pdo = fo != null && fo.isFolder() ? ProjectDataObject.findPDO(fo) : ProjectDataObject.createProject(projects, DEFAULT_PROJECT_NAME);
        return pdo;
    }

    public static void copyProjectContent(DataFolder srcPrj, DataFolder trgPrj) throws IOException {
        ProjectDataObject.copyProjectContent(srcPrj, trgPrj, new String[0]);
    }

    public static void copyProjectContent(DataFolder srcPrj, DataFolder trgPrj, String[] filter) throws IOException {
        FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
        FileObject src = srcPrj.getPrimaryFile();
        FileObject trg = trgPrj.getPrimaryFile();
        boolean isMFS = false;
        if (src.getFileSystem().equals(sfs)) {
            src = ProjectDataObject.getLocalFromSFS(src);
        } else if (src.getFileSystem() instanceof MultiFileSystem) {
            isMFS = true;
        }
        if (trg.getFileSystem().equals(sfs)) {
            trg = ProjectDataObject.getLocalFromSFS(trg);
        } else if (trg.getFileSystem() instanceof MultiFileSystem) {
            isMFS = true;
        }
        if (isMFS) {
            throw new IOException("Unable to copy project from/to MultiFileSystem, please file a bug in http://www.netbeans.org/issues/enter_bug.cgi against the projects module and attach this stack trace. Thanks.");
        }
        ProjectDataObject.copyContentR(src, trg, filter);
        ProjectDataObject.copyAttributes(srcPrj.getPrimaryFile(), trgPrj.getPrimaryFile());
        trgPrj.getPrimaryFile().refresh();
    }

    public ProjectDataObject(FileObject obj, DataLoader loader) throws DataObjectExistsException {
        super(obj, loader);
        this.cookies.put(class$org$openide$cookies$ProjectCookie == null ? (class$org$openide$cookies$ProjectCookie = ProjectDataObject.class$("org.openide.cookies.ProjectCookie")) : class$org$openide$cookies$ProjectCookie, this.support);
        this.cookies.put(class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = ProjectDataObject.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile, new C(class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = ProjectDataObject.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile));
        this.cookies.put(class$org$openide$cookies$CompilerCookie$Clean == null ? (class$org$openide$cookies$CompilerCookie$Clean = ProjectDataObject.class$("org.openide.cookies.CompilerCookie$Clean")) : class$org$openide$cookies$CompilerCookie$Clean, new C(class$org$openide$cookies$CompilerCookie$Clean == null ? (class$org$openide$cookies$CompilerCookie$Clean = ProjectDataObject.class$("org.openide.cookies.CompilerCookie$Clean")) : class$org$openide$cookies$CompilerCookie$Clean));
        this.cookies.put(class$org$openide$cookies$CompilerCookie$Build == null ? (class$org$openide$cookies$CompilerCookie$Build = ProjectDataObject.class$("org.openide.cookies.CompilerCookie$Build")) : class$org$openide$cookies$CompilerCookie$Build, new C(class$org$openide$cookies$CompilerCookie$Build == null ? (class$org$openide$cookies$CompilerCookie$Build = ProjectDataObject.class$("org.openide.cookies.CompilerCookie$Build")) : class$org$openide$cookies$CompilerCookie$Build));
        this.cookies.put(class$org$openide$cookies$DebuggerCookie == null ? (class$org$openide$cookies$DebuggerCookie = ProjectDataObject.class$("org.openide.cookies.DebuggerCookie")) : class$org$openide$cookies$DebuggerCookie, new DE());
        this.cookies.put(class$org$openide$cookies$ExecCookie == null ? (class$org$openide$cookies$ExecCookie = ProjectDataObject.class$("org.openide.cookies.ExecCookie")) : class$org$openide$cookies$ExecCookie, new DE());
    }

    public void add(DataObject dobj) throws IOException {
        dobj.createShadow(this.getFilesFolder());
    }

    public boolean isCurrentProject() {
        CurrentProjectNode node = CurrentProjectNode.getDefault();
        return node != null && node.getCookie(class$org$netbeans$modules$projects$ProjectDataObject == null ? (class$org$netbeans$modules$projects$ProjectDataObject = ProjectDataObject.class$("org.netbeans.modules.projects.ProjectDataObject")) : class$org$netbeans$modules$projects$ProjectDataObject) == this;
    }

    public boolean isDeleteAllowed() {
        return super.isDeleteAllowed() && !this.isCurrentProject();
    }

    public boolean isMoveAllowed() {
        return super.isMoveAllowed() && !this.isCurrentProject();
    }

    public Node.Cookie getCookie(Class c) {
        Object cookie = null;
        if (this.isValid()) {
            cookie = (class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = ProjectDataObject.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder).equals(c) || (class$org$openide$loaders$DataObject$Container == null ? (class$org$openide$loaders$DataObject$Container = ProjectDataObject.class$("org.openide.loaders.DataObject$Container")) : class$org$openide$loaders$DataObject$Container).equals(c) ? this.getFilesFolder() : (Node.Cookie)this.cookies.get(c);
        }
        if (cookie == null) {
            cookie = super.getCookie(c);
        }
        return cookie;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$projects$ProjectDataObject == null ? (class$org$netbeans$modules$projects$ProjectDataObject = ProjectDataObject.class$("org.netbeans.modules.projects.ProjectDataObject")) : class$org$netbeans$modules$projects$ProjectDataObject);
    }

    public boolean isAccessibleFromFolder(DataObject dobj) {
        DataFolder dF = this.getFilesFolder();
        if (dF == null || dobj == null) {
            return false;
        }
        DataObject[] ch = dF.getChildren();
        int i = 0;
        while (i < ch.length) {
            if (ch[i] instanceof DataShadow ? dobj == ((DataShadow)ch[i]).getOriginal() : ch[i] == dobj) {
                return true;
            }
            ++i;
        }
        return this.isAccessibleFromFolder((DataObject)dobj.getFolder());
    }

    public DataFolder getFilesFolder() {
        DataFolder df = null;
        try {
            final FileObject[] ff = new FileObject[]{null};
            this.getPrimaryFile().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    Object object = LOCK;
                    synchronized (object) {
                        ff[0] = ProjectDataObject.this.getPrimaryFile().getFileObject(ProjectDataObject.FILES_FOLDER);
                        if (ff[0] == null) {
                            ff[0] = ProjectDataObject.this.getPrimaryFile().createFolder(ProjectDataObject.FILES_FOLDER);
                        }
                    }
                }
            });
            if (ff[0] != null) {
                df = DataFolder.findFolder((FileObject)ff[0]);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return df;
    }

    public FileObject getProjectLayerDir() throws IOException {
        FileObject layer = this.getPrimaryFile().getFileObject(PROJECT_LAYER_FOLDER);
        if (layer == null) {
            layer = this.getPrimaryFile().createFolder(PROJECT_LAYER_FOLDER);
        }
        return layer;
    }

    protected DataObject handleCopy(DataFolder f) throws IOException {
        FileObject primary = this.getPrimaryFile();
        ProjectDataObject newFolder = ProjectDataObject.createProjectImpl(f, primary.getName(), primary.getExt(), false);
        ProjectDataObject.copyProjectContent(this, newFolder);
        return newFolder;
    }

    protected void handleDelete() throws IOException {
        if (!this.isCurrentProject()) {
            super.handleDelete();
        }
    }

    protected Node createNodeDelegate() {
        return new ProjectDataNode(this);
    }

    private static void copyAttributes(FileObject src, FileObject trg) throws IOException {
        Enumeration attrKeys = src.getAttributes();
        while (attrKeys.hasMoreElements()) {
            String key = (String)attrKeys.nextElement();
            Object value = src.getAttribute(key);
            trg.setAttribute(key, value);
        }
    }

    private static void copyContentR(FileObject src, FileObject trg, String[] filter) throws IOException {
        FileObject[] ch = src.getChildren();
        int i = 0;
        while (i < ch.length) {
            if (!ProjectDataObject.isFiltered(filter, ch[i].getPath())) {
                FileObject f;
                if (ch[i].isFolder()) {
                    f = trg.getFileObject(ch[i].getNameExt());
                    if (f == null) {
                        f = trg.createFolder(ch[i].getNameExt());
                    }
                    ProjectDataObject.copyAttributes(ch[i], f);
                    ProjectDataObject.copyContentR(ch[i], f, filter);
                } else {
                    f = ch[i].copy(trg, ch[i].getName(), ch[i].getExt());
                    ProjectDataObject.copyAttributes(ch[i], f);
                }
            }
            ++i;
        }
    }

    private static boolean isFiltered(String[] filter, String s) {
        int i = 0;
        while (i < filter.length) {
            if (s.endsWith(filter[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static FileObject getLocalFromSFS(FileObject fo) {
        String root = null;
        LocalFileSystem lfs = null;
        root = System.getProperty("netbeans.user");
        if (null == root) {
            root = System.getProperty("netbeans.home");
        }
        if (root != null) {
            try {
                lfs = new LocalFileSystem();
                lfs.setRootDirectory(new File(root, PROJECT_LAYER_FOLDER));
            }
            catch (Exception e) {
                lfs = null;
            }
        }
        return lfs == null ? null : lfs.findResource(fo.getPackageNameExt('/', '.'));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class DE
    implements DebuggerCookie,
    ExecCookie {
        static /* synthetic */ Class class$org$openide$cookies$DebuggerCookie;
        static /* synthetic */ Class class$org$openide$cookies$ExecCookie;
        static /* synthetic */ Class class$org$netbeans$modules$projects$settings$ProjectOption;
        static /* synthetic */ Class class$org$netbeans$modules$projects$SetMainClassAction;

        private DE() {
        }

        public void debug(boolean stopOnMain) throws DebuggerException {
            DebuggerCookie dc;
            DataObject dobj = this.getMainClassObject();
            if (dobj != null && (dc = (DebuggerCookie)dobj.getCookie(class$org$openide$cookies$DebuggerCookie == null ? (class$org$openide$cookies$DebuggerCookie = DE.class$("org.openide.cookies.DebuggerCookie")) : class$org$openide$cookies$DebuggerCookie)) != null) {
                dc.debug(stopOnMain);
            }
        }

        public void start() {
            ExecCookie ec;
            DataObject dobj = this.getMainClassObject();
            if (dobj != null && (ec = (ExecCookie)dobj.getCookie(class$org$openide$cookies$ExecCookie == null ? (class$org$openide$cookies$ExecCookie = DE.class$("org.openide.cookies.ExecCookie")) : class$org$openide$cookies$ExecCookie)) != null) {
                ec.start();
            }
        }

        private DataObject getMainClassObject() {
            ProjectOption opt = (ProjectOption)SharedClassObject.findObject((Class)(class$org$netbeans$modules$projects$settings$ProjectOption == null ? (class$org$netbeans$modules$projects$settings$ProjectOption = DE.class$("org.netbeans.modules.projects.settings.ProjectOption")) : class$org$netbeans$modules$projects$settings$ProjectOption), (boolean)true);
            DataObject dobj = opt.getMainClass();
            if (dobj == null) {
                SetMainClassAction a = (SetMainClassAction)SystemAction.get((Class)(class$org$netbeans$modules$projects$SetMainClassAction == null ? (class$org$netbeans$modules$projects$SetMainClassAction = DE.class$("org.netbeans.modules.projects.SetMainClassAction")) : class$org$netbeans$modules$projects$SetMainClassAction));
                a.performAction();
                dobj = opt.getMainClass();
            }
            return dobj;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private final class C
    implements CompilerCookie.Compile,
    CompilerCookie.Build,
    CompilerCookie.Clean {
        private CompilerCookie cookie = null;

        public C(Class c) {
            try {
                this.cookie = (CompilerCookie)ProjectDataObject.this.getFilesFolder().getCookie(c);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }

        public void addToJob(CompilerJob job, Compiler.Depth depth) {
            if (this.cookie != null) {
                this.cookie.addToJob(job, Compiler.DEPTH_INFINITE);
            }
        }

        public boolean isDepthSupported(Compiler.Depth depth) {
            return true;
        }
    }
}

