/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class ProjectManager
implements TaskListener {
    public static final String PROP_FINISHED = "finished";
    private static ProjectManager manager = null;
    private RequestProcessor PROCESSOR = new RequestProcessor("Projects processor");
    private RequestProcessor.Task projectTask = null;
    private Vector listeners = new Vector(1);

    public static synchronized ProjectManager getDefault() {
        if (manager == null) {
            manager = new ProjectManager();
        }
        return manager;
    }

    public Task processTask(Runnable task) {
        ProjectManager projectManager = this;
        synchronized (projectManager) {
            if (!this.isFinished()) {
                throw new IllegalStateException("Previous task is still in progress.");
            }
            this.projectTask = this.PROCESSOR.create(task);
            this.projectTask.addTaskListener((TaskListener)this);
        }
        this.fireFinishedChanged(false);
        ProjectManager projectManager2 = this;
        synchronized (projectManager2) {
            this.projectTask.schedule(0);
            RequestProcessor.Task task2 = this.projectTask;
            return task2;
        }
    }

    public synchronized boolean isFinished() {
        return this.projectTask == null || this.projectTask.isFinished();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.remove(l);
    }

    private ProjectManager() {
    }

    private void fireFinishedChanged(boolean value) {
        Vector toFire = (Vector)this.listeners.clone();
        Iterator i = ((AbstractList)toFire).iterator();
        while (i.hasNext() && value == this.isFinished()) {
            PropertyChangeListener l = (PropertyChangeListener)i.next();
            l.propertyChange(new PropertyChangeEvent(this, PROP_FINISHED, !value ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE));
        }
    }

    public void taskFinished(Task task) {
        task.removeTaskListener((TaskListener)this);
        ProjectManager projectManager = this;
        synchronized (projectManager) {
            this.projectTask = null;
        }
        this.fireFinishedChanged(true);
    }
}

