/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.projects.NewProjectAction;
import org.netbeans.modules.projects.PSupport;
import org.netbeans.modules.projects.ProjectDataObject;
import org.netbeans.modules.projects.ProjectManager;
import org.netbeans.modules.projects.SaveFilesDialog;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.ActionManager;
import org.openide.awt.Actions;
import org.openide.cookies.ProjectCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

public class ProjectManagerPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
ActionListener {
    public static final String PROP_CLOSE_DIALOG = "PROP_CLOSE_DIALOG";
    private ExplorerManager manager;
    private JButton deleteButton;
    private JButton importButton;
    private JButton newButton;
    private JButton openButton;
    private ListView projectList;
    private JLabel projectListLabel;
    private JButton renameButton;
    private JButton saveAsButton;
    static /* synthetic */ Class class$org$netbeans$modules$projects$ProjectManagerPanel;
    static /* synthetic */ Class class$org$netbeans$modules$projects$importing$ImportProjectAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$netbeans$modules$projects$ProjectDataObject;

    public ProjectManagerPanel() {
        this.initComponents();
        this.initAccessibility();
        this.initMnemonics();
        this.updateButtonState();
        this.getExplorerManager().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)this.getExplorerManager()));
        ProjectManager.getDefault().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)ProjectManager.getDefault()));
        this.projectList.setDefaultProcessor((ActionListener)this);
    }

    private void setAccessible(JComponent c, String key) {
        c.getAccessibleContext().setAccessibleDescription(ProjectManagerPanel.getString(key));
    }

    private void initMnemonics() {
        Actions.setMenuText((AbstractButton)this.newButton, (String)NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$ProjectManagerPanel == null ? (class$org$netbeans$modules$projects$ProjectManagerPanel = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectManagerPanel")) : class$org$netbeans$modules$projects$ProjectManagerPanel), (String)"CTL_New"), (boolean)true);
        Actions.setMenuText((AbstractButton)this.openButton, (String)NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$ProjectManagerPanel == null ? (class$org$netbeans$modules$projects$ProjectManagerPanel = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectManagerPanel")) : class$org$netbeans$modules$projects$ProjectManagerPanel), (String)"CTL_Open"), (boolean)true);
        Actions.setMenuText((AbstractButton)this.importButton, (String)NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$ProjectManagerPanel == null ? (class$org$netbeans$modules$projects$ProjectManagerPanel = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectManagerPanel")) : class$org$netbeans$modules$projects$ProjectManagerPanel), (String)"CTL_Import"), (boolean)true);
        Actions.setMenuText((AbstractButton)this.saveAsButton, (String)NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$ProjectManagerPanel == null ? (class$org$netbeans$modules$projects$ProjectManagerPanel = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectManagerPanel")) : class$org$netbeans$modules$projects$ProjectManagerPanel), (String)"CTL_SaveAs"), (boolean)true);
        Actions.setMenuText((AbstractButton)this.deleteButton, (String)NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$ProjectManagerPanel == null ? (class$org$netbeans$modules$projects$ProjectManagerPanel = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectManagerPanel")) : class$org$netbeans$modules$projects$ProjectManagerPanel), (String)"CTL_Delete"), (boolean)true);
        Actions.setMenuText((AbstractButton)this.renameButton, (String)NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$ProjectManagerPanel == null ? (class$org$netbeans$modules$projects$ProjectManagerPanel = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectManagerPanel")) : class$org$netbeans$modules$projects$ProjectManagerPanel), (String)"CTL_Rename"), (boolean)true);
    }

    private void initAccessibility() {
        this.projectListLabel.setLabelFor((Component)this.projectList);
        this.setAccessible(this.projectListLabel, "ACS_ProjectList");
        this.setAccessible(this.newButton, "ACS_New");
        this.setAccessible(this.openButton, "ACS_Open");
        this.setAccessible(this.importButton, "ACS_Import");
        this.setAccessible(this.saveAsButton, "ACS_SaveAs");
        this.setAccessible(this.deleteButton, "ACS_Delete");
        this.setAccessible(this.renameButton, "ACS_Rename");
        this.setAccessible(this, "ACSD_ProjectManager");
    }

    private void initComponents() {
        this.projectListLabel = new JLabel();
        this.projectListLabel.setDisplayedMnemonic(ProjectManagerPanel.getString("CTL_ExistingProjects_Mnem").charAt(0));
        this.projectList = new ListView();
        this.newButton = new JButton();
        this.importButton = new JButton();
        this.openButton = new JButton();
        this.saveAsButton = new JButton();
        this.deleteButton = new JButton();
        this.renameButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.setMaximumSize(new Dimension(600, 600));
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(400, 300));
        this.projectListLabel.setLabelFor((Component)this.projectList);
        this.projectListLabel.setText(ProjectManagerPanel.getString("CTL_ExistingProjects"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.projectListLabel, gridBagConstraints);
        this.projectList.setTraversalAllowed(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.add((Component)this.projectList, gridBagConstraints);
        this.newButton.setText(ProjectManagerPanel.getString("CTL_New"));
        this.newButton.setToolTipText(NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$ProjectManagerPanel == null ? (class$org$netbeans$modules$projects$ProjectManagerPanel = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectManagerPanel")) : class$org$netbeans$modules$projects$ProjectManagerPanel), (String)"LBL_ProjectManagerPanel_newButton_tooltip"));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectManagerPanel.this.newButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.newButton, gridBagConstraints);
        this.importButton.setText(ProjectManagerPanel.getString("CTL_Import"));
        this.importButton.setToolTipText(NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$ProjectManagerPanel == null ? (class$org$netbeans$modules$projects$ProjectManagerPanel = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectManagerPanel")) : class$org$netbeans$modules$projects$ProjectManagerPanel), (String)"LBL_ProjectManagerPanel_importButton_tooltip"));
        this.importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectManagerPanel.this.importButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.importButton, gridBagConstraints);
        this.openButton.setText(ProjectManagerPanel.getString("CTL_Open"));
        this.openButton.setToolTipText(NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$ProjectManagerPanel == null ? (class$org$netbeans$modules$projects$ProjectManagerPanel = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectManagerPanel")) : class$org$netbeans$modules$projects$ProjectManagerPanel), (String)"LBL_ProjectManagerPanel_openButton_tooltip"));
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectManagerPanel.this.openButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.openButton, gridBagConstraints);
        this.saveAsButton.setText(ProjectManagerPanel.getString("CTL_SaveAs"));
        this.saveAsButton.setToolTipText(NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$ProjectManagerPanel == null ? (class$org$netbeans$modules$projects$ProjectManagerPanel = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectManagerPanel")) : class$org$netbeans$modules$projects$ProjectManagerPanel), (String)"LBL_ProjectManagerPanel_saveAsButton_tooltip"));
        this.saveAsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectManagerPanel.this.saveAsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.saveAsButton, gridBagConstraints);
        this.deleteButton.setText(ProjectManagerPanel.getString("CTL_Delete"));
        this.deleteButton.setToolTipText(NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$ProjectManagerPanel == null ? (class$org$netbeans$modules$projects$ProjectManagerPanel = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectManagerPanel")) : class$org$netbeans$modules$projects$ProjectManagerPanel), (String)"LBL_ProjectManagerPanel_deleteButton_tooltip"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectManagerPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.deleteButton, gridBagConstraints);
        this.renameButton.setText(ProjectManagerPanel.getString("CTL_Rename"));
        this.renameButton.setToolTipText(NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$ProjectManagerPanel == null ? (class$org$netbeans$modules$projects$ProjectManagerPanel = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectManagerPanel")) : class$org$netbeans$modules$projects$ProjectManagerPanel), (String)"LBL_ProjectManagerPanel_renameButton_tooltip"));
        this.renameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectManagerPanel.this.renameButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.add((Component)this.renameButton, gridBagConstraints);
    }

    private void importButtonActionPerformed(ActionEvent evt) {
        this.importButton.setEnabled(false);
        SystemAction a = SystemAction.get((Class)(class$org$netbeans$modules$projects$importing$ImportProjectAction == null ? (class$org$netbeans$modules$projects$importing$ImportProjectAction = ProjectManagerPanel.class$("org.netbeans.modules.projects.importing.ImportProjectAction")) : class$org$netbeans$modules$projects$importing$ImportProjectAction));
        a.actionPerformed(new ActionEvent(this, 1001, null));
        this.updateButtonState();
    }

    private void renameButtonActionPerformed(ActionEvent evt) {
        Node[] na = this.getExplorerManager().getSelectedNodes();
        if (na != null && na.length == 1) {
            this.renameButton.setEnabled(false);
            SystemAction a = SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = ProjectManagerPanel.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction));
            a.actionPerformed(new ActionEvent(na[0], 1001, null));
            this.clearListSelection();
            this.updateButtonState();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteButtonActionPerformed(ActionEvent evt) {
        Node[] n;
        block4: {
            this.deleteButton.setEnabled(false);
            try {
                block6: {
                    block5: {
                        n = this.getExplorerManager().getSelectedNodes();
                        if (n == null) break block5;
                        if (n.length != 0) break block6;
                    }
                    Object var5_3 = null;
                    this.updateButtonState();
                    return;
                }
                NotifyDescriptor.Confirmation confirm = new NotifyDescriptor.Confirmation((Object)ProjectManagerPanel.getString("MSG_ConfirmDelete"));
                if (NotifyDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)confirm)) break block4;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.updateButtonState();
                throw throwable;
            }
            Object var5_4 = null;
            this.updateButtonState();
            return;
        }
        Object var5_5 = null;
        this.updateButtonState();
        ProjectManager.getDefault().processTask(new Runnable(){
            static /* synthetic */ Class class$org$netbeans$modules$projects$ProjectDataObject;

            public void run() {
                try {
                    int i = 0;
                    while (i < n.length) {
                        ProjectDataObject prj = (ProjectDataObject)n[i].getCookie(class$org$netbeans$modules$projects$ProjectDataObject == null ? 7.class$("org.netbeans.modules.projects.ProjectDataObject") : class$org$netbeans$modules$projects$ProjectDataObject);
                        if (prj != null) {
                            prj.getPrimaryFile().delete();
                        }
                        ++i;
                    }
                }
                catch (IOException x) {
                    ErrorManager.getDefault().notify((Throwable)x);
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveAsButtonActionPerformed(ActionEvent evt) {
        String name;
        ProjectDataObject prj;
        block7: {
            block8: {
                block6: {
                    this.saveAsButton.setEnabled(false);
                    try {
                        Node[] na;
                        block10: {
                            block9: {
                                na = this.getExplorerManager().getSelectedNodes();
                                if (na == null) break block9;
                                if (na.length == 1) break block10;
                            }
                            Object var6_3 = null;
                            this.updateButtonState();
                            return;
                        }
                        prj = (ProjectDataObject)na[0].getCookie(class$org$netbeans$modules$projects$ProjectDataObject == null ? (class$org$netbeans$modules$projects$ProjectDataObject = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectDataObject")) : class$org$netbeans$modules$projects$ProjectDataObject);
                        if (prj == null) {
                            break block6;
                        }
                        name = NewProjectAction.getProjectName(prj.getName(), ProjectManagerPanel.getString("CTL_RenameLabel"), ProjectManagerPanel.getString("CTL_SaveAsDialogTitle"));
                        if (name != null) break block7;
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        this.updateButtonState();
                        throw throwable;
                    }
                }
                Object var6_4 = null;
                this.updateButtonState();
                return;
            }
            Object var6_5 = null;
            this.updateButtonState();
            return;
        }
        Object var6_6 = null;
        this.updateButtonState();
        ProjectManager.getDefault().processTask(new Runnable(){
            static /* synthetic */ Class class$org$openide$cookies$ProjectCookie;

            public void run() {
                try {
                    if (prj.isCurrentProject()) {
                        ProjectCookie pc = (ProjectCookie)prj.getCookie(class$org$openide$cookies$ProjectCookie == null ? (class$org$openide$cookies$ProjectCookie = 8.class$("org.openide.cookies.ProjectCookie")) : class$org$openide$cookies$ProjectCookie);
                        pc.projectSave();
                    }
                    DataFolder df = PSupport.getProjectsFolder();
                    Repository.getDefault().getDefaultFileSystem().runAtomicAction(new FileSystem.AtomicAction(this, df){
                        private final /* synthetic */ DataFolder val$df;
                        private final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$df = val$df;
                        }

                        public void run() throws IOException {
                            ProjectDataObject newPrj = ProjectDataObject.createProject(this.val$df, 8.access$600(this.this$1));
                            ProjectDataObject.copyProjectContent(8.access$700(this.this$1), newPrj);
                        }
                    });
                }
                catch (IOException x) {
                    ErrorManager.getDefault().notify((Throwable)x);
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }

            static /* synthetic */ String access$600(8 x0) {
                return x0.name;
            }

            static /* synthetic */ ProjectDataObject access$700(8 x0) {
                return x0.prj;
            }
        });
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        this.firePropertyChange(PROP_CLOSE_DIALOG, null, null);
        SwingUtilities.invokeLater(new Runnable(){
            static /* synthetic */ Class class$org$openide$actions$ActionManager;
            static /* synthetic */ Class class$org$netbeans$modules$projects$NewProjectAction;

            public void run() {
                ActionManager am = (ActionManager)Lookup.getDefault().lookup(class$org$openide$actions$ActionManager == null ? (class$org$openide$actions$ActionManager = 10.class$("org.openide.actions.ActionManager")) : class$org$openide$actions$ActionManager);
                am.invokeAction((Action)SystemAction.get((Class)(class$org$netbeans$modules$projects$NewProjectAction == null ? (class$org$netbeans$modules$projects$NewProjectAction = 10.class$("org.netbeans.modules.projects.NewProjectAction")) : class$org$netbeans$modules$projects$NewProjectAction)), new ActionEvent(this, 1001, null));
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        final Node[] n = this.getExplorerManager().getSelectedNodes();
        if (n == null || n.length != 1) {
            return;
        }
        if (!SaveFilesDialog.showDialog(false)) {
            return;
        }
        this.firePropertyChange(PROP_CLOSE_DIALOG, null, null);
        ProjectManager.getDefault().processTask(new Runnable(){
            static /* synthetic */ Class class$org$openide$cookies$ProjectCookie;

            public void run() {
                try {
                    ProjectCookie c = (ProjectCookie)n[0].getCookie(class$org$openide$cookies$ProjectCookie == null ? (class$org$openide$cookies$ProjectCookie = 11.class$("org.openide.cookies.ProjectCookie")) : class$org$openide$cookies$ProjectCookie);
                    PSupport.openProject(c);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
    }

    private void updateButtonState() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateButtonStateAWT();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProjectManagerPanel.this.updateButtonStateAWT();
                }
            });
        }
    }

    private void updateButtonStateAWT() {
        if (!ProjectManager.getDefault().isFinished()) {
            this.newButton.setEnabled(false);
            this.openButton.setEnabled(false);
            this.importButton.setEnabled(false);
            this.saveAsButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.renameButton.setEnabled(false);
            return;
        }
        Node[] n = this.getExplorerManager().getSelectedNodes();
        this.newButton.setEnabled(true);
        this.importButton.setEnabled(true);
        boolean enabled = false;
        if (n != null && n.length > 0) {
            enabled = true;
            int i = 0;
            while (i < n.length) {
                if (!n[i].canDestroy()) {
                    enabled = false;
                    break;
                }
                ++i;
            }
        }
        this.deleteButton.setEnabled(enabled);
        enabled = false;
        if (n != null && n.length == 1) {
            ProjectDataObject prj = (ProjectDataObject)n[0].getCookie(class$org$netbeans$modules$projects$ProjectDataObject == null ? (class$org$netbeans$modules$projects$ProjectDataObject = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectDataObject")) : class$org$netbeans$modules$projects$ProjectDataObject);
            enabled = !prj.isCurrentProject();
        }
        this.openButton.setEnabled(enabled);
        enabled = n != null && n.length == 1;
        this.renameButton.setEnabled(enabled);
        this.saveAsButton.setEnabled(enabled);
    }

    private void clearListSelection() {
        Runnable task = new Runnable(){

            public void run() {
                try {
                    ProjectManagerPanel.this.getExplorerManager().setSelectedNodes(new Node[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            SwingUtilities.invokeLater(task);
        }
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            ProjectManagerPanel projectManagerPanel = this;
            synchronized (projectManagerPanel) {
                if (this.manager == null) {
                    this.manager = new ExplorerManager();
                }
            }
        }
        return this.manager;
    }

    private static String getString(String key) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$ProjectManagerPanel == null ? (class$org$netbeans$modules$projects$ProjectManagerPanel = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectManagerPanel")) : class$org$netbeans$modules$projects$ProjectManagerPanel), (String)key);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("finished".equals(evt.getPropertyName())) {
            this.clearListSelection();
        }
        this.updateButtonState();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.openButton.isEnabled()) {
            this.openButtonActionPerformed(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

