/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects;

import java.io.IOException;
import java.io.ObjectOutputStream;
import org.netbeans.core.projects.TrivialProjectManager;
import org.netbeans.modules.projects.PSupport;
import org.netbeans.modules.projects.ProjectDataLoader;
import org.netbeans.modules.projects.ProjectDataObject;
import org.netbeans.modules.projects.SaveFilesDialog;
import org.openide.ErrorManager;
import org.openide.cookies.ProjectCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.modules.ModuleInstall;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;

public class ProjectsModule
extends ModuleInstall {
    public static final String PROJECT_LAST_NAME = "project";
    public static final String PROJECT_LAST_EXT = "last";
    static final long serialVersionUID = -8515854707471314270L;
    static /* synthetic */ Class class$org$netbeans$core$projects$TrivialProjectManager;
    static /* synthetic */ Class class$org$netbeans$modules$projects$ProjectDataLoader;

    public void restored() {
        this.checkProjectsConsistency();
        try {
            if (!this.lastExists()) {
                ProjectDataObject pdo = ProjectDataObject.createDefaultProject();
                this.saveLast(pdo.support);
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public void installed() {
        this.restored();
    }

    public void uninstalled() {
        SaveFilesDialog.showDialog(true);
        this.removeLast();
        try {
            TrivialProjectManager tpm = (TrivialProjectManager)Lookup.getDefault().lookup(class$org$netbeans$core$projects$TrivialProjectManager == null ? (class$org$netbeans$core$projects$TrivialProjectManager = ProjectsModule.class$("org.netbeans.core.projects.TrivialProjectManager")) : class$org$netbeans$core$projects$TrivialProjectManager);
            tpm.load();
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    public boolean closing() {
        return SaveFilesDialog.showDialog(false);
    }

    private boolean lastExists() {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject system = fs.getRoot();
        FileObject last = system.getFileObject(PROJECT_LAST_NAME, PROJECT_LAST_EXT);
        return last != null;
    }

    /*
     * Loose catch block
     */
    private void saveLast(ProjectCookie project) {
        block15: {
            ObjectOutputStream oos;
            FileLock lock;
            block14: {
                lock = null;
                oos = null;
                FileSystem fs = Repository.getDefault().getDefaultFileSystem();
                FileObject system = fs.getRoot();
                FileObject last = system.getFileObject(PROJECT_LAST_NAME, PROJECT_LAST_EXT);
                if (last == null) {
                    last = system.createData(PROJECT_LAST_NAME, PROJECT_LAST_EXT);
                }
                lock = last.lock();
                oos = new ObjectOutputStream(last.getOutputStream(lock));
                oos.writeObject(project);
                Object var8_8 = null;
                if (lock == null) break block14;
                lock.releaseLock();
            }
            try {
                if (oos != null) {
                    oos.close();
                }
                break block15;
            }
            catch (IOException ex2) {
                ErrorManager.getDefault().notify(1, (Throwable)ex2);
            }
            break block15;
            {
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                    Object var8_9 = null;
                    if (lock != null) {
                        lock.releaseLock();
                    }
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                        break block15;
                    }
                    catch (IOException ex2) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (lock != null) {
                    lock.releaseLock();
                }
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException ex2) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeLast() {
        FileLock lock = null;
        try {
            block4: {
                try {
                    FileSystem fs = Repository.getDefault().getDefaultFileSystem();
                    FileObject system = fs.getRoot();
                    FileObject last = system.getFileObject(PROJECT_LAST_NAME, PROJECT_LAST_EXT);
                    if (last == null) break block4;
                    lock = last.lock();
                    last.delete(lock);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                    Object var6_7 = null;
                    if (lock == null) return;
                    lock.releaseLock();
                    return;
                }
            }
            Object var6_6 = null;
            if (lock == null) return;
            lock.releaseLock();
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (lock == null) throw throwable;
            lock.releaseLock();
            throw throwable;
        }
    }

    private void checkProjectsConsistency() {
        DataFolder projects = PSupport.getProjectsFolder();
        if (projects != null) {
            DataObject[] prjs = projects.getChildren();
            int i = 0;
            while (i < prjs.length) {
                if (prjs[i].getPrimaryFile().isFolder() && !(prjs[i] instanceof ProjectDataObject)) {
                    try {
                        ProjectDataLoader pdl = (ProjectDataLoader)SharedClassObject.findObject((Class)(class$org$netbeans$modules$projects$ProjectDataLoader == null ? ProjectsModule.class$("org.netbeans.modules.projects.ProjectDataLoader") : class$org$netbeans$modules$projects$ProjectDataLoader), (boolean)true);
                        DataLoaderPool.setPreferredLoader((FileObject)prjs[i].getPrimaryFile(), (DataLoader)pdl);
                        prjs[i].setValid(false);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

