/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects.content;

import java.awt.Dialog;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.FeatureDescriptor;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.netbeans.modules.projects.CurrentProjectNode;
import org.netbeans.modules.projects.content.ProjectErrorsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;

public class ProjectErrorManager {
    public static final int TYPE_FILE = 1;
    public static final int TYPE_SCO = 2;
    public static final int TYPE_ITEM = 3;
    public static final int TYPE_WM = 5;
    static final String PROP_ERROR_DETAILS = "details";
    private static String[] missingPackages = null;
    private List exceptions = new ArrayList();
    private AllErrorsNode errorsRootNode;
    private ProjectErrorsPanel panel;
    static /* synthetic */ Class class$org$netbeans$modules$projects$content$ProjectErrorManager;

    public void annotate(int type, String name, Throwable t) {
        this.annotate(type, name, t, true);
    }

    public void annotate(int type, String name, Throwable t, boolean notify) {
        if (t instanceof StreamCorruptedException) {
            ErrorManager.getDefault().notify(1, t);
        } else if (!this.isExpectedException(t)) {
            ListEntry li = new ListEntry(type, name, t);
            this.exceptions.add(li);
            this.getErrorsRootNode().getChildren().add(new Node[]{new ErrorNode(li)});
            if (notify) {
                ErrorManager.getDefault().annotate(t, li.toString());
                ErrorManager.getDefault().notify(1, t);
            }
        }
    }

    public void clear() {
        this.exceptions.clear();
        this.errorsRootNode = null;
    }

    public void show() {
        if (!this.isEmpty()) {
            ProjectErrorsPanel p = this.getPanel();
            p.getExplorerManager().setRootContext((Node)this.getErrorsRootNode());
            p.updateDescription();
            DialogDescriptor dd = new DialogDescriptor((Object)p, ProjectErrorManager.getString("CTL_ErrorsDialogTitle"));
            dd.setModal(false);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.show();
        }
    }

    public boolean isEmpty() {
        return this.exceptions.isEmpty();
    }

    private ProjectErrorsPanel getPanel() {
        if (this.panel == null) {
            this.panel = new ProjectErrorsPanel();
        }
        return this.panel;
    }

    private AllErrorsNode getErrorsRootNode() {
        if (this.errorsRootNode == null) {
            this.errorsRootNode = new AllErrorsNode();
        }
        return this.errorsRootNode;
    }

    private static String getString(String key) {
        try {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$content$ProjectErrorManager == null ? (class$org$netbeans$modules$projects$content$ProjectErrorManager = ProjectErrorManager.class$("org.netbeans.modules.projects.content.ProjectErrorManager")) : class$org$netbeans$modules$projects$content$ProjectErrorManager), (String)key);
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace();
            return "Missing resource";
        }
    }

    private boolean isExpectedException(Throwable t) {
        LinkedList<Throwable> allExceptions = new LinkedList<Throwable>();
        ErrorManager.Annotation[] an = ErrorManager.getDefault().findAnnotations(t);
        allExceptions.add(t);
        if (an != null) {
            int i = 0;
            while (i < an.length) {
                allExceptions.add(an[i].getStackTrace());
                ++i;
            }
        }
        Iterator i = allExceptions.iterator();
        while (i.hasNext()) {
            Throwable exc = (Throwable)i.next();
            if (!(exc instanceof ClassNotFoundException)) continue;
            String[] mp = this.getMissingPackages();
            int j = 0;
            while (j < mp.length) {
                if (-1 != exc.getMessage().indexOf(mp[j])) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    private synchronized String[] getMissingPackages() {
        if (null == missingPackages) {
            try {
                ResourceBundle rb = NbBundle.getBundle((String)"org.netbeans.modules.projects.content.IgnoredPackages");
                Enumeration<String> keys = rb.getKeys();
                LinkedList<String> l = new LinkedList<String>();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    l.add(rb.getString(key));
                }
                missingPackages = l.toArray(new String[l.size()]);
            }
            catch (MissingResourceException e) {
                missingPackages = new String[0];
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return missingPackages;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ErrorNode
    extends AbstractNode {
        private ListEntry entry;

        public ErrorNode(ListEntry entry) {
            super(Children.LEAF);
            this.entry = entry;
            ((FeatureDescriptor)((Object)this)).setValue(ProjectErrorManager.PROP_ERROR_DETAILS, entry);
            this.setIconBase("org/netbeans/modules/projects/resources/ErrorNodeIcon");
            this.setName(ProjectErrorManager.getString("LBL_ErrorNode"));
            this.setDisplayName(entry.name);
            String description = ProjectErrorManager.getString("HINT_ErrorNode");
            switch (entry.type) {
                case 1: {
                    description = ProjectErrorManager.getString("MSG_ErrorTypeFile");
                    break;
                }
                case 2: {
                    description = ProjectErrorManager.getString("MSG_ErrorTypeSCO");
                    break;
                }
                case 3: {
                    description = ProjectErrorManager.getString("MSG_ErrorTypeItem");
                    break;
                }
                case 5: {
                    description = ProjectErrorManager.getString("MSG_ErrorTypeWindowManager");
                }
            }
            this.setShortDescription(description);
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public Node cloneNode() {
            return new ErrorNode(this.entry);
        }

        public boolean canCopy() {
            return true;
        }

        public boolean canCut() {
            return false;
        }

        public Transferable clipboardCopy() {
            try {
                ExTransferable et = ExTransferable.create((Transferable)super.clipboardCopy());
                et.put(new ExTransferable.Single(this, DataFlavor.stringFlavor){
                    private final /* synthetic */ ErrorNode this$0;
                    {
                        this.this$0 = this$0;
                    }

                    protected Object getData() {
                        return ((FeatureDescriptor)((Object)this.this$0)).getDisplayName();
                    }
                });
                return et;
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                return ExTransferable.EMPTY;
            }
        }
    }

    private class AllErrorsNode
    extends AbstractNode {
        static /* synthetic */ Class class$org$netbeans$modules$projects$content$ProjectErrorManager;

        public AllErrorsNode() {
            super((Children)new Children.Array());
            this.setIconBase("org/netbeans/modules/projects/resources/AllErrorsNodeIcon");
            CurrentProjectNode n = CurrentProjectNode.getDefault();
            String name = NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$content$ProjectErrorManager == null ? (class$org$netbeans$modules$projects$content$ProjectErrorManager = AllErrorsNode.class$("org.netbeans.modules.projects.content.ProjectErrorManager")) : class$org$netbeans$modules$projects$content$ProjectErrorManager), (String)"LBL_AllErrorsNode", (Object)((FeatureDescriptor)((Object)n)).getName());
            this.setName(name);
            this.setDisplayName(name);
            this.setShortDescription(ProjectErrorManager.getString("HINT_AllErrorsNode"));
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public Node cloneNode() {
            return new AllErrorsNode();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class ListEntry {
        int type;
        String name;
        Throwable t;
        static /* synthetic */ Class class$org$netbeans$modules$projects$content$ProjectErrorManager;

        public ListEntry(int type, String name, Throwable t) {
            this.type = type;
            this.name = name;
            this.t = t;
        }

        public String toString() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$content$ProjectErrorManager == null ? (class$org$netbeans$modules$projects$content$ProjectErrorManager = ListEntry.class$("org.netbeans.modules.projects.content.ProjectErrorManager")) : class$org$netbeans$modules$projects$content$ProjectErrorManager), (String)"FMT_ErrorText", (Object)new Integer(this.type), (Object)this.name, (Object)this.t);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

