/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects.content;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.projects.DumbXMLDataLoader;
import org.netbeans.modules.projects.content.DiffSet;
import org.netbeans.modules.projects.content.OptionProcessor;
import org.netbeans.modules.projects.content.ProjectContent;
import org.netbeans.modules.projects.content.ProjectErrorManager;
import org.netbeans.modules.projects.content.SettingsSet;
import org.netbeans.modules.projects.content.XMLSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.NbObjectInputStream;

public class XMLProjectContent
implements ProjectContent {
    public static final String VERSION = "1.1";
    private static final boolean DEBUG = false;
    public static final String EXT_PROJECT_DATA = "xml";
    public static final String EXT_SER = "ser";
    public static final String NAME_CONTROL_PANEL = "cpanel";
    public static final String NAME_LOADERS = "loaders";
    public static final String NAME_REPOSITORY = "repository";
    public static final String NAME_SERVICES = "services";
    public static final String NAME_WORKSPACE = "workspace";
    public static final String SETTINGS_SET_ELEMENT = "SettingsSet";
    private XMLSettingsSet cpanel;
    private XMLSettingsSet loaders;
    private XMLDiffSet repository;
    private XMLDiffSet services;
    private static ProjectErrorManager pem;
    private DataFolder dfolder;
    private ProjectContent superProject;

    public XMLProjectContent(DataFolder dfolder, ProjectContent superProject, ProjectErrorManager pem) {
        this.dfolder = dfolder;
        this.superProject = superProject;
        XMLProjectContent.pem = pem;
    }

    public ProjectContent getSuperProject() {
        return this.superProject;
    }

    public SettingsSet getControlPanel() {
        if (this.cpanel == null) {
            this.cpanel = this.loadSettingsSet(new XMLSettingsSet(), NAME_CONTROL_PANEL);
        }
        return this.cpanel;
    }

    public SettingsSet getLoaderPool() {
        if (this.loaders == null) {
            this.loaders = this.loadSettingsSet(new XMLSettingsSet(), NAME_LOADERS);
        }
        return this.loaders;
    }

    public DiffSet getRepository() {
        if (this.repository == null) {
            this.repository = this.loadDiffSet(new XMLDiffSet(), NAME_REPOSITORY);
        }
        return this.repository;
    }

    public DiffSet getServices() {
        if (this.services == null) {
            this.services = this.loadDiffSet(new XMLDiffSet(), NAME_SERVICES);
        }
        return this.services;
    }

    /*
     * Loose catch block
     */
    public NbMarshalledObject getWindowManager() {
        NbMarshalledObject nmo;
        block12: {
            nmo = null;
            FileObject ff = this.dfolder.getPrimaryFile();
            FileObject fo = ff.getFileObject(NAME_WORKSPACE, EXT_SER);
            if (fo != null) {
                ObjectInputStream ois = null;
                ois = new NbObjectInputStream((InputStream)new BufferedInputStream(fo.getInputStream(), 16384));
                nmo = (NbMarshalledObject)ois.readObject();
                Object var7_5 = null;
                try {
                    if (ois != null) {
                        ois.close();
                    }
                    break block12;
                }
                catch (Exception ex2) {}
                break block12;
                {
                    catch (Exception ex) {
                        pem.annotate(1, ff.getPackageName('/') + '/' + NAME_WORKSPACE + '.' + EXT_SER, ex, true);
                        Object var7_6 = null;
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                            break block12;
                        }
                        catch (Exception ex2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return nmo;
    }

    /*
     * Loose catch block
     */
    private XMLSettingsSet loadSettingsSet(XMLSettingsSet set, String name) {
        block12: {
            FileObject fo = this.getFileObject(name, EXT_PROJECT_DATA, false);
            if (fo != null) {
                BufferedReader reader = null;
                reader = new BufferedReader(new InputStreamReader(fo.getInputStream()));
                Map map = XMLSupport.loadObjects(reader, new HashMap(), SETTINGS_SET_ELEMENT);
                set.setRawData(map);
                Object var7_7 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    break block12;
                }
                catch (Exception ex2) {}
                break block12;
                {
                    catch (Exception ex) {
                        pem.annotate(1, fo.getPackageNameExt('/', '.'), ex, true);
                        Object var7_8 = null;
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            break block12;
                        }
                        catch (Exception ex2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return set;
    }

    /*
     * Loose catch block
     */
    private XMLDiffSet loadDiffSet(XMLDiffSet set, String name) {
        block12: {
            FileObject fo = this.getFileObject(name, EXT_PROJECT_DATA, false);
            if (fo != null) {
                BufferedReader reader = null;
                reader = new BufferedReader(new InputStreamReader(fo.getInputStream()));
                XMLSupport.loadDiffSet(reader, set);
                Object var7_5 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    break block12;
                }
                catch (Exception ex2) {}
                break block12;
                {
                    catch (Exception ex) {
                        pem.annotate(1, fo.getPackageNameExt('/', '.'), ex, true);
                        Object var7_6 = null;
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            break block12;
                        }
                        catch (Exception ex2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return set;
    }

    private FileObject getFileObject(final String name, final String ext, boolean create) {
        final FileObject ff = this.dfolder.getPrimaryFile();
        final FileObject[] fo = new FileObject[]{ff.getFileObject(name, ext)};
        if (fo[0] == null && create) {
            try {
                ff.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){
                    static /* synthetic */ Class class$org$netbeans$modules$projects$DumbXMLDataLoader;

                    public void run() throws IOException {
                        try {
                            fo[0] = ff.createData(name, ext);
                        }
                        catch (Exception ex) {
                            ProjectErrorManager projectErrorManager = pem;
                            pem;
                            projectErrorManager.annotate(1, ff.getPackageName('/') + '/' + name + '.' + ext, ex, true);
                            return;
                        }
                        try {
                            ((DumbXMLDataLoader)SharedClassObject.findObject((Class)(class$org$netbeans$modules$projects$DumbXMLDataLoader == null ? (class$org$netbeans$modules$projects$DumbXMLDataLoader = 1.class$("org.netbeans.modules.projects.DumbXMLDataLoader")) : class$org$netbeans$modules$projects$DumbXMLDataLoader), (boolean)true)).markFile(fo[0]);
                            DataObject dobj = DataObject.find((FileObject)fo[0]);
                            if (dobj.getClass() != (class$org$netbeans$modules$projects$DumbXMLDataLoader == null ? (class$org$netbeans$modules$projects$DumbXMLDataLoader = 1.class$("org.netbeans.modules.projects.DumbXMLDataLoader")) : class$org$netbeans$modules$projects$DumbXMLDataLoader)) {
                                dobj.setValid(false);
                            }
                            dobj = DataObject.find((FileObject)fo[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    static /* synthetic */ Class class$(String x0) {
                        try {
                            return Class.forName(x0);
                        }
                        catch (ClassNotFoundException x1) {
                            throw new NoClassDefFoundError(x1.getMessage());
                        }
                    }
                });
            }
            catch (Exception ex) {
                pem.annotate(1, ff.getPackageName('/') + '/' + name + '.' + ext, ex, true);
            }
        }
        return fo[0];
    }

    class XMLSettingsSet
    implements SettingsSet {
        private HashSet set;
        private Map rawData;
        static /* synthetic */ Class class$java$lang$ClassLoader;

        XMLSettingsSet() {
        }

        public synchronized boolean contains(SharedClassObject obj) {
            if (this.set != null) {
                return this.set.contains(obj.getClass().getName());
            }
            return false;
        }

        public synchronized void add(SharedClassObject obj) {
            if (this.set == null) {
                this.set = new HashSet(16);
            }
            this.set.add(obj);
        }

        public synchronized void remove(SharedClassObject obj) {
            if (this.set != null) {
                this.set.remove(obj);
            }
        }

        public synchronized void clear() {
            this.set = null;
        }

        public synchronized Collection getObjects() {
            if (this.set != null) {
                return new HashSet(this.set);
            }
            return new HashSet(4);
        }

        public synchronized void setRawData(Map map) {
            this.rawData = new HashMap(map);
            this.set = new HashSet(this.rawData.size());
            Iterator it = this.rawData.entrySet().iterator();
            ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = XMLSettingsSet.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = entry.getKey().toString();
                try {
                    Class<?> clazz = cl.loadClass(name);
                    this.set.add(SharedClassObject.findObject(clazz, (boolean)true));
                }
                catch (Exception ex) {
                    it.remove();
                    ProjectErrorManager projectErrorManager = pem;
                    pem;
                    projectErrorManager.annotate(2, name, ex);
                }
            }
        }

        public synchronized Map getRawData() {
            if (this.rawData != null) {
                return new HashMap(this.rawData);
            }
            return new HashMap(4);
        }

        public synchronized void read(OptionProcessor processor) {
            if (this.set != null && this.rawData != null) {
                Iterator it = this.set.iterator();
                while (it.hasNext()) {
                    SharedClassObject sco = (SharedClassObject)it.next();
                    if (!processor.canProcess(sco)) continue;
                    try {
                        String rawString = (String)this.rawData.get(sco.getClass().getName());
                        if (rawString == null) continue;
                        XMLSupport.decodeValue(rawString);
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable th) {
                        ProjectErrorManager projectErrorManager = pem;
                        pem;
                        projectErrorManager.annotate(2, sco.getClass().getName(), th);
                    }
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class XMLDiffSet
    implements DiffSet {
        private List items;
        private Map addMap;
        private Set removeSet;
        private boolean clear = true;
        private String version;

        public synchronized void add(String name, Object value) {
            if (this.removeSet != null) {
                this.removeSet.remove(name);
            }
            if (this.items == null) {
                this.items = new LinkedList();
            }
            if (!this.items.contains(name)) {
                this.items.add(name);
            }
            if (this.addMap == null) {
                this.addMap = new HashMap(16);
            }
            this.addMap.put(name, value);
        }

        public synchronized void addRaw(String name, String rawString) {
            try {
                if (rawString != null) {
                    Object obj = XMLSupport.decodeValue(rawString);
                    this.add(name, obj);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (ClassNotFoundException ex) {
                if (!ex.getMessage().equals("org.netbeans.core.SystemFileSystem")) {
                    ProjectErrorManager projectErrorManager = pem;
                    pem;
                    projectErrorManager.annotate(3, name, ex);
                }
            }
            catch (Throwable th) {
                ProjectErrorManager projectErrorManager = pem;
                pem;
                projectErrorManager.annotate(3, name, th);
            }
        }

        public synchronized void remove(String name) {
            if (this.items != null) {
                this.items.remove(name);
            }
            if (this.addMap != null) {
                this.addMap.remove(name);
            }
            if (this.removeSet == null) {
                this.removeSet = new HashSet(16);
            }
            this.removeSet.add(name);
        }

        public synchronized List addedItems() {
            if (this.items != null) {
                return new ArrayList(this.items);
            }
            return new ArrayList(0);
        }

        public synchronized Object addedItem(String name) {
            if (this.addMap != null) {
                return this.addMap.get(name);
            }
            return null;
        }

        public synchronized String addedRawItem(String name) {
            Object obj = this.addedItem(name);
            if (obj != null) {
                try {
                    return XMLSupport.encodeValue(obj);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    ProjectErrorManager projectErrorManager = pem;
                    pem;
                    projectErrorManager.annotate(3, name, th);
                }
            }
            return null;
        }

        public synchronized Set removedItems() {
            if (this.removeSet != null) {
                return new HashSet(this.removeSet);
            }
            return new HashSet(4);
        }

        public boolean isClear() {
            return this.clear;
        }

        public void setClear(boolean clear) {
            this.clear = clear;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String ver) {
            this.version = ver;
        }

        public synchronized void clear() {
            this.items = null;
            this.removeSet = null;
            this.addMap = null;
        }
    }
}

