/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects.content;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.modules.projects.content.HandlerDiffSet;
import org.netbeans.modules.projects.content.HandlerObjects;
import org.netbeans.modules.projects.content.XMLProjectContent;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Utilities;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class XMLSupport {
    public static final String EMPTY_STRING = "";
    public static final String FMT_XML_HEADER = "<?xml version=\"1.0\"?>";
    public static final String FMT_OBJECTS_START = "<{0} version=\"1.1\">";
    public static final String FMT_OBJECTS_END = "</{0}>";
    public static final String ELEMENT_CONTROL_PANEL = "control-panel";
    public static final String ELEMENT_MODULES = "modules";
    public static final String ELEMENT_LOADERS = "loaders";

    private XMLSupport() {
    }

    static String encodeToProperXML(String text) {
        if (text.indexOf(38) != -1) {
            text = Utilities.replaceString((String)text, (String)"&", (String)"&amp;");
        }
        if (text.indexOf(60) != -1) {
            text = Utilities.replaceString((String)text, (String)"<", (String)"&lt;");
        }
        if (text.indexOf(62) != -1) {
            text = Utilities.replaceString((String)text, (String)">", (String)"&gt;");
        }
        if (text.indexOf(39) != -1) {
            text = Utilities.replaceString((String)text, (String)"'", (String)"&apos;");
        }
        if (text.indexOf(34) != -1) {
            text = Utilities.replaceString((String)text, (String)"\"", (String)"&quot;");
        }
        if (text.indexOf(10) != -1) {
            text = Utilities.replaceString((String)text, (String)"\n", (String)"&#xa;");
        }
        if (text.indexOf(9) != -1) {
            text = Utilities.replaceString((String)text, (String)"\t", (String)"&#x9;");
        }
        return text;
    }

    static Object decodeValue(String value) throws Throwable {
        if (value == null || value.length() == 0) {
            return null;
        }
        char[] bisChars = value.toCharArray();
        byte[] bytes = new byte[bisChars.length];
        char[] singleNum = new char[4];
        int snCount = 0;
        int count = 0;
        int i = 0;
        while (i < bisChars.length) {
            if (',' == bisChars[i]) {
                bytes[count++] = XMLSupport.parseByte(singleNum, snCount);
                snCount = 0;
            } else {
                singleNum[snCount++] = bisChars[i];
            }
            ++i;
        }
        bytes[count++] = XMLSupport.parseByte(singleNum, snCount);
        return XMLSupport.deserializeValue(bytes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object deserializeValue(byte[] bytes) throws Throwable {
        Object object;
        if (bytes == null) {
            throw new NullPointerException();
        }
        ObjectInputStream ois = null;
        try {
            Object ret;
            ois = new NbObjectInputStream((InputStream)new ByteArrayInputStream(bytes, 0, bytes.length));
            object = ret = ois.readObject();
            Object var5_4 = null;
            if (ois == null) return object;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (ois == null) throw throwable;
            ois.close();
            throw throwable;
        }
        ois.close();
        return object;
    }

    static byte parseByte(char[] chars, int len) throws NumberFormatException {
        int idx = 0;
        boolean negative = false;
        if (chars[0] == '-') {
            negative = true;
            ++idx;
        }
        int ret = 0;
        while (idx < len) {
            int tmp = chars[idx] - 48;
            if (tmp < 0 || tmp > 9) {
                throw new NumberFormatException();
            }
            ret *= 10;
            ret += tmp;
            ++idx;
        }
        if (negative) {
            ret = -ret;
        }
        if (ret < -128 || ret > 127) {
            throw new NumberFormatException();
        }
        return (byte)ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] serializeValue(Object value) throws Throwable {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        NbObjectOutputStream oos = null;
        try {
            oos = new NbObjectOutputStream((OutputStream)bos);
            oos.writeObject(value);
            Object var4_3 = null;
            if (oos == null) return bos.toByteArray();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oos == null) throw throwable;
            oos.close();
            throw throwable;
        }
        oos.close();
        return bos.toByteArray();
    }

    static String encodeValue(Object obj) throws Throwable {
        if (obj == null) {
            return null;
        }
        byte[] bosBytes = XMLSupport.serializeValue(obj);
        StringBuffer sb = new StringBuffer(bosBytes.length * 4 + 2);
        int i = 0;
        while (i < bosBytes.length - 1) {
            sb.append(bosBytes[i]).append(',');
            ++i;
        }
        sb.append(bosBytes[bosBytes.length - 1]);
        return sb.toString();
    }

    public static String encodeStrings(List list) {
        Iterator it = list.iterator();
        StringBuffer sb = new StringBuffer();
        boolean comma = false;
        boolean i = false;
        while (it.hasNext()) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append(XMLSupport.encodeToProperXML((String)it.next()));
        }
        return sb.toString();
    }

    public static List decodeStrings(String value) {
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    public static void saveObjects(Writer writer, Map map, String mainElement) {
        Object[] formatObjs = new Object[]{mainElement};
        PrintWriter pw = new PrintWriter(writer);
        pw.println(FMT_XML_HEADER);
        pw.println(MessageFormat.format(FMT_OBJECTS_START, formatObjs));
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            String rawString = (String)map.get(name);
            if (rawString == null) continue;
            pw.print("  <object name=\"");
            pw.print(XMLSupport.encodeToProperXML(name));
            pw.print("\" value=\"");
            pw.print(rawString);
            pw.println("\"/>");
        }
        pw.println(MessageFormat.format(FMT_OBJECTS_END, formatObjs));
        pw.flush();
    }

    public static Map loadObjects(Reader reader, Map map, String mainElement) throws IOException, SAXException {
        Parser parser = XMLDataObject.createParser();
        HandlerObjects handler = new HandlerObjects(map, mainElement);
        parser.setDocumentHandler(handler);
        parser.parse(new InputSource(reader));
        return map;
    }

    public static void loadDiffSet(Reader reader, XMLProjectContent.XMLDiffSet diffset) throws IOException, SAXException {
        Parser parser = XMLDataObject.createParser();
        HandlerDiffSet handler = new HandlerDiffSet(diffset);
        parser.setDocumentHandler(handler);
        parser.parse(new InputSource(reader));
    }

    public static void saveDiffSet(Writer writer, XMLProjectContent.XMLDiffSet diffset) throws IOException {
        String item;
        PrintWriter pw = new PrintWriter(writer);
        pw.println(FMT_XML_HEADER);
        pw.println("<diff-set clear=\"" + diffset.isClear() + "\" version=\"" + "1.1" + "\">");
        Iterator it = diffset.addedItems().iterator();
        while (it.hasNext()) {
            item = (String)it.next();
            pw.print("  <add name=\"");
            pw.print(XMLSupport.encodeToProperXML(item));
            pw.print("\" value=\"");
            pw.print(diffset.addedRawItem(item));
            pw.println("\"/>");
        }
        it = diffset.removedItems().iterator();
        while (it.hasNext()) {
            item = (String)it.next();
            pw.print("  <remove name=\"");
            pw.print(XMLSupport.encodeToProperXML(item));
            pw.println("\"/>");
        }
        pw.println("</diff-set>");
    }

    public static boolean isNew(String version, String projectVersion) throws NumberFormatException {
        if (version == null || version.length() < 1) {
            throw new NumberFormatException("Empty version string");
        }
        StringTokenizer vtok = new StringTokenizer(version, ".", true);
        StringTokenizer tok = new StringTokenizer(projectVersion, ".", true);
        while (vtok.hasMoreTokens() || tok.hasMoreTokens()) {
            int ver;
            int vver = vtok.hasMoreTokens() ? Integer.parseInt(vtok.nextToken()) : 0;
            if (vver < (ver = tok.hasMoreTokens() ? Integer.parseInt(tok.nextToken()) : 0)) {
                throw new IllegalArgumentException("Specified version is older than the projecVersion");
            }
            if (vver > ver) {
                return true;
            }
            if (vtok.hasMoreTokens()) {
                vtok.nextToken();
            }
            if (!tok.hasMoreTokens()) continue;
            tok.nextToken();
        }
        return false;
    }
}

