/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.ObjectArrayPanel2;
import org.openide.src.Identifier;
import org.openide.src.Type;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class IdentifierArrayEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    IdentifierArrayPanel panel;
    boolean ignoreEditor = false;
    boolean ignorePanel = false;
    PropertyEnv env;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$editors$IdentifierArrayEditor;

    public String getAsText() {
        Identifier[] id = (Identifier[])this.getValue();
        if (id == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < id.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(id[i].getSourceName());
            ++i;
        }
        return buf.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        StringTokenizer tukac = new StringTokenizer(text, ", ", false);
        ArrayList<Identifier> list = new ArrayList<Identifier>();
        while (tukac.hasMoreTokens()) {
            String id = tukac.nextToken();
            try {
                Type t = Type.parse(id);
                if (!t.isClass()) {
                    throw new IllegalArgumentException();
                }
            }
            catch (IllegalArgumentException ex) {
                String msg = MessageFormat.format(IdentifierArrayEditor.getString("MSG_InvalidIdentifier"), id);
                ErrorManager.getDefault().annotate((Throwable)ex, 256, null, msg, null, null);
                throw ex;
            }
            list.add(Identifier.create(id));
        }
        Identifier[] ret = new Identifier[list.size()];
        list.toArray(ret);
        this.setValue(ret);
    }

    public void setValue(Object o) {
        this.ignoreEditor = true;
        boolean saveIgnorePanel = this.ignorePanel;
        this.ignorePanel = false;
        super.setValue(o);
        if (this.panel != null & !saveIgnorePanel) {
            this.panel.setIdentifiers((Identifier[])o);
        }
        this.ignoreEditor = false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.panel == null) {
            this.panel = new IdentifierArrayPanel();
            this.panel.setIdentifiers((Identifier[])this.getValue());
            this.panel.setMnemonics(this.env);
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (!IdentifierArrayEditor.this.ignoreEditor && "identifiers".equals(evt.getPropertyName())) {
                        IdentifierArrayEditor.this.ignorePanel = true;
                        IdentifierArrayEditor.this.setValue(evt.getNewValue());
                        IdentifierArrayEditor.this.ignorePanel = false;
                    }
                }
            });
        }
        return this.panel;
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
    }

    private static String getString(String key) {
        return NbBundle.getBundle((String)"org.openide.explorer.propertysheet.editors.Bundle2", (Locale)Locale.getDefault(), (ClassLoader)(class$org$openide$explorer$propertysheet$editors$IdentifierArrayEditor == null ? (class$org$openide$explorer$propertysheet$editors$IdentifierArrayEditor = IdentifierArrayEditor.class$("org.openide.explorer.propertysheet.editors.IdentifierArrayEditor")) : class$org$openide$explorer$propertysheet$editors$IdentifierArrayEditor).getClassLoader()).getString(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class IdentifierArrayPanel
    extends ObjectArrayPanel2 {
        public static final String PROP_IDENTIFIERS = "identifiers";
        Identifier[] prevValue = new Identifier[0];
        static final long serialVersionUID = -8655189809250688928L;

        public IdentifierArrayPanel() {
            this.getListComponent().setCellRenderer(new DefaultListCellRenderer(this){
                private final /* synthetic */ IdentifierArrayPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (comp == this) {
                        this.setText(((Identifier)value).getFullName());
                    }
                    return comp;
                }
            });
        }

        public Identifier[] getIdentifiers() {
            Object[] ret = new Identifier[this.model.size()];
            this.model.copyInto(ret);
            return ret;
        }

        public void setIdentifiers(Identifier[] data) {
            this.model = new DefaultListModel();
            if (data != null) {
                int i = 0;
                while (i < data.length) {
                    this.model.addElement(data[i]);
                    ++i;
                }
            }
            this.getListComponent().setModel(this.model);
            this.modelChanged();
        }

        protected void modelChanged() {
            Identifier[] newValue = this.getIdentifiers();
            this.firePropertyChange(PROP_IDENTIFIERS, this.prevValue, newValue);
            this.prevValue = newValue;
        }

        protected Object insertNewValue() {
            return this.openInputDialog(null);
        }

        protected Object editValue(Object oldValue) {
            return this.openInputDialog((Identifier)oldValue);
        }

        protected Identifier openInputDialog(Identifier origValue) {
            Object ret;
            NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(IdentifierArrayEditor.getString("LAB_NewName"), IdentifierArrayEditor.getString("LAB_NewIdentifier"));
            if (origValue != null) {
                input.setInputText(origValue.getSourceName());
            }
            while ((ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)input)) == NotifyDescriptor.OK_OPTION) {
                String retValue = input.getInputText();
                if (!(retValue == null || "".equals(retValue) || retValue.startsWith(".") || retValue.endsWith(".") || retValue.indexOf("..") != -1)) {
                    boolean ok = true;
                    StringTokenizer tokenizer = new StringTokenizer(retValue, ".", false);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (Utilities.isJavaIdentifier((String)token)) continue;
                        ok = false;
                        break;
                    }
                    if (ok) {
                        return Identifier.create(retValue);
                    }
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)IdentifierArrayEditor.getString("MSG_NotValidID")));
            }
            return null;
        }
    }
}

